@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Raw failure information if DNS verification fails.
 * @property code Standardized string to programmatically identify the error.
 * @property details Details or the error
 * @property message Detailed error description and debugging information.
 * @property target Detailed error description and debugging information.
 */
public data class CustomHostnameAnalysisResultResponseCustomDomainVerificationFailureInfo(
    public val code: String,
    public val details: List<CustomHostnameAnalysisResultResponseDetails>? = null,
    public val message: String,
    public val target: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.CustomHostnameAnalysisResultResponseCustomDomainVerificationFailureInfo):
            CustomHostnameAnalysisResultResponseCustomDomainVerificationFailureInfo =
            CustomHostnameAnalysisResultResponseCustomDomainVerificationFailureInfo(
                code = javaType.code(),
                details = javaType.details().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.CustomHostnameAnalysisResultResponseDetails.Companion.toKotlin(args0)
                    })
                }),
                message = javaType.message(),
                target = javaType.target(),
            )
    }
}
