@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Dapr PubSub Bulk Subscription Options.
 * @property enabled Enable bulk subscription
 * @property maxAwaitDurationMs Maximum duration in milliseconds to wait before a bulk message is sent to the app.
 * @property maxMessagesCount Maximum number of messages to deliver in a bulk message.
 */
public data class DaprSubscriptionBulkSubscribeOptionsResponse(
    public val enabled: Boolean? = null,
    public val maxAwaitDurationMs: Int? = null,
    public val maxMessagesCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.DaprSubscriptionBulkSubscribeOptionsResponse):
            DaprSubscriptionBulkSubscribeOptionsResponse = DaprSubscriptionBulkSubscribeOptionsResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            maxAwaitDurationMs = javaType.maxAwaitDurationMs().map({ args0 -> args0 }).orElse(null),
            maxMessagesCount = javaType.maxMessagesCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
