@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Dapr Pubsub Event Subscription Route Rule is used to specify the condition for sending a message to a specific path.
 * @property match The optional CEL expression used to match the event. If the match is not specified, then the route is considered the default. The rules are tested in the order specified, so they should be define from most-to-least specific. The default route should appear last in the list.
 * @property path The path for events that match this rule
 */
public data class DaprSubscriptionRouteRuleResponse(
    public val match: String? = null,
    public val path: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.DaprSubscriptionRouteRuleResponse):
            DaprSubscriptionRouteRuleResponse = DaprSubscriptionRouteRuleResponse(
            match = javaType.match().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
