@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Dapr PubSub Event Subscription Routes configuration.
 * @property default The default path to deliver events that do not match any of the rules.
 * @property rules The list of Dapr PubSub Event Subscription Route Rules.
 */
public data class DaprSubscriptionRoutesResponse(
    public val default: String? = null,
    public val rules: List<DaprSubscriptionRouteRuleResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.DaprSubscriptionRoutesResponse):
            DaprSubscriptionRoutesResponse = DaprSubscriptionRoutesResponse(
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.DaprSubscriptionRouteRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
