@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of a forward proxy used to make the requests.
 * @property convention The convention used to determine the url of the request made.
 * @property customHostHeaderName The name of the header containing the host of the request.
 * @property customProtoHeaderName The name of the header containing the scheme of the request.
 */
public data class ForwardProxyResponse(
    public val convention: String? = null,
    public val customHostHeaderName: String? = null,
    public val customProtoHeaderName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ForwardProxyResponse):
            ForwardProxyResponse = ForwardProxyResponse(
            convention = javaType.convention().map({ args0 -> args0 }).orElse(null),
            customHostHeaderName = javaType.customHostHeaderName().map({ args0 -> args0 }).orElse(null),
            customProtoHeaderName = javaType.customProtoHeaderName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
