@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Defines parameters for http connection pooling
 * @property http1MaxPendingRequests Maximum number of pending http1 requests allowed
 * @property http2MaxRequests Maximum number of http2 requests allowed
 */
public data class HttpConnectionPoolResponse(
    public val http1MaxPendingRequests: Int? = null,
    public val http2MaxRequests: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.HttpConnectionPoolResponse):
            HttpConnectionPoolResponse = HttpConnectionPoolResponse(
            http1MaxPendingRequests = javaType.http1MaxPendingRequests().map({ args0 -> args0 }).orElse(null),
            http2MaxRequests = javaType.http2MaxRequests().map({ args0 -> args0 }).orElse(null),
        )
    }
}
