@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model representing a http get request.
 * @property fileName Name of the file that the request should be saved to.
 * @property headers List of headers to send with the request.
 * @property url URL to make HTTP GET request against.
 */
public data class HttpGetResponse(
    public val fileName: String? = null,
    public val headers: List<String>? = null,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.HttpGetResponse):
            HttpGetResponse = HttpGetResponse(
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0 }),
            url = javaType.url(),
        )
    }
}
