@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Policy that defines http request retry conditions
 * @property errors Errors that can trigger a retry
 * @property headers Headers that must be present for a request to be retried
 * @property httpStatusCodes Additional http status codes that can trigger a retry
 * @property initialDelayInMilliseconds Initial delay, in milliseconds, before retrying a request
 * @property maxIntervalInMilliseconds Maximum interval, in milliseconds, between retries
 * @property maxRetries Maximum number of times a request will retry
 */
public data class HttpRetryPolicyResponse(
    public val errors: List<String>? = null,
    public val headers: List<HeaderMatchResponse>? = null,
    public val httpStatusCodes: List<Int>? = null,
    public val initialDelayInMilliseconds: Double? = null,
    public val maxIntervalInMilliseconds: Double? = null,
    public val maxRetries: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.HttpRetryPolicyResponse):
            HttpRetryPolicyResponse = HttpRetryPolicyResponse(
            errors = javaType.errors().map({ args0 -> args0 }),
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.HeaderMatchResponse.Companion.toKotlin(args0)
                })
            }),
            httpStatusCodes = javaType.httpStatusCodes().map({ args0 -> args0 }),
            initialDelayInMilliseconds = javaType.initialDelayInMilliseconds().map({ args0 ->
                args0
            }).orElse(null),
            maxIntervalInMilliseconds = javaType.maxIntervalInMilliseconds().map({ args0 ->
                args0
            }).orElse(null),
            maxRetries = javaType.maxRetries().map({ args0 -> args0 }).orElse(null),
        )
    }
}
