@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container App init container definition
 * @property args Container start command arguments.
 * @property command Container start command.
 * @property env Container environment variables.
 * @property image Container image tag.
 * @property name Custom container name.
 * @property resources Container resource requirements.
 * @property volumeMounts Container volume mounts.
 */
public data class InitContainerResponse(
    public val args: List<String>? = null,
    public val command: List<String>? = null,
    public val env: List<EnvironmentVarResponse>? = null,
    public val image: String? = null,
    public val name: String? = null,
    public val resources: ContainerResourcesResponse? = null,
    public val volumeMounts: List<VolumeMountResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.InitContainerResponse):
            InitContainerResponse = InitContainerResponse(
            args = javaType.args().map({ args0 -> args0 }),
            command = javaType.command().map({ args0 -> args0 }),
            env = javaType.env().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.EnvironmentVarResponse.Companion.toKotlin(args0)
                })
            }),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ContainerResourcesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            volumeMounts = javaType.volumeMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.VolumeMountResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
