@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Trigger configuration of an event driven job.
 * @property parallelism Number of parallel replicas of a job that can run at a given time.
 * @property replicaCompletionCount Minimum number of successful replica completions before overall job completion.
 * @property scale Scaling configurations for event driven jobs.
 */
public data class JobConfigurationResponseEventTriggerConfig(
    public val parallelism: Int? = null,
    public val replicaCompletionCount: Int? = null,
    public val scale: JobScaleResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JobConfigurationResponseEventTriggerConfig):
            JobConfigurationResponseEventTriggerConfig = JobConfigurationResponseEventTriggerConfig(
            parallelism = javaType.parallelism().map({ args0 -> args0 }).orElse(null),
            replicaCompletionCount = javaType.replicaCompletionCount().map({ args0 -> args0 }).orElse(null),
            scale = javaType.scale().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.JobScaleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
