@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be set to 1 by default
 * @property parallelism Number of parallel replicas of a job that can run at a given time.
 * @property replicaCompletionCount Minimum number of successful replica completions before overall job completion.
 */
public data class JobConfigurationResponseManualTriggerConfig(
    public val parallelism: Int? = null,
    public val replicaCompletionCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JobConfigurationResponseManualTriggerConfig):
            JobConfigurationResponseManualTriggerConfig = JobConfigurationResponseManualTriggerConfig(
            parallelism = javaType.parallelism().map({ args0 -> args0 }).orElse(null),
            replicaCompletionCount = javaType.replicaCompletionCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
