@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Build Auth Token.
 * @property expires Token expiration date.
 * @property token Authentication token.
 */
public data class ListBuildAuthTokenResult(
    public val expires: String,
    public val token: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ListBuildAuthTokenResult):
            ListBuildAuthTokenResult = ListBuildAuthTokenResult(
            expires = javaType.expires(),
            token = javaType.token(),
        )
    }
}
