@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration used to control the Environment Egress outbound traffic
 * @property outBoundType Outbound type for the cluster
 * @property virtualNetworkApplianceIp Virtual Appliance IP used as the Egress controller for the Environment
 */
public data class ManagedEnvironmentOutboundSettingsResponse(
    public val outBoundType: String? = null,
    public val virtualNetworkApplianceIp: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ManagedEnvironmentOutboundSettingsResponse):
            ManagedEnvironmentOutboundSettingsResponse = ManagedEnvironmentOutboundSettingsResponse(
            outBoundType = javaType.outBoundType().map({ args0 -> args0 }).orElse(null),
            virtualNetworkApplianceIp = javaType.virtualNetworkApplianceIp().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
