@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.getReportPlain
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetReportPlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetReportPlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetReportResult
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetReportResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object AppcomplianceautomationFunctions {
    /**
     * Get the AppComplianceAutomation report and its properties.
     * Azure REST API version: 2022-11-16-preview.
     * @param argument null
     * @return A class represent an AppComplianceAutomation report resource.
     */
    public suspend fun getReport(argument: GetReportPlainArgs): GetReportResult =
        toKotlin(getReportPlain(argument.toJava()).await())

    /**
     * @see [getReport].
     * @param reportName Report Name.
     * @return A class represent an AppComplianceAutomation report resource.
     */
    public suspend fun getReport(reportName: String): GetReportResult {
        val argument = GetReportPlainArgs(
            reportName = reportName,
        )
        return toKotlin(getReportPlain(argument.toJava()).await())
    }

    /**
     * @see [getReport].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;GetReportPlainArgs].
     * @return A class represent an AppComplianceAutomation report resource.
     */
    public suspend fun getReport(argument: suspend GetReportPlainArgsBuilder.() -> Unit):
        GetReportResult {
        val builder = GetReportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getReportPlain(builtArgument.toJava()).await())
    }
}
