@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs

import com.pulumi.azurenative.appcomplianceautomation.inputs.ReportPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Report's properties.
 * @property offerGuid Report offer Guid.
 * @property resources List of resource data.
 * @property timeZone Report collection trigger time's time zone, the available list can be obtained by executing "Get-TimeZone -ListAvailable" in PowerShell.
 * An example of valid timezone id is "Pacific Standard Time".
 * @property triggerTime Report collection trigger time.
 */
public data class ReportPropertiesArgs(
    public val offerGuid: Output<String>? = null,
    public val resources: Output<List<ResourceMetadataArgs>>,
    public val timeZone: Output<String>,
    public val triggerTime: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.inputs.ReportPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.inputs.ReportPropertiesArgs =
        com.pulumi.azurenative.appcomplianceautomation.inputs.ReportPropertiesArgs.builder()
            .offerGuid(offerGuid?.applyValue({ args0 -> args0 }))
            .resources(
                resources.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeZone(timeZone.applyValue({ args0 -> args0 }))
            .triggerTime(triggerTime.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportPropertiesArgs].
 */
@PulumiTagMarker
public class ReportPropertiesArgsBuilder internal constructor() {
    private var offerGuid: Output<String>? = null

    private var resources: Output<List<ResourceMetadataArgs>>? = null

    private var timeZone: Output<String>? = null

    private var triggerTime: Output<String>? = null

    /**
     * @param value Report offer Guid.
     */
    @JvmName("ffurmfykdewknqxm")
    public suspend fun offerGuid(`value`: Output<String>) {
        this.offerGuid = value
    }

    /**
     * @param value List of resource data.
     */
    @JvmName("bbwuriucmxoivpkt")
    public suspend fun resources(`value`: Output<List<ResourceMetadataArgs>>) {
        this.resources = value
    }

    @JvmName("dmmyrpebscyjqwev")
    public suspend fun resources(vararg values: Output<ResourceMetadataArgs>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values List of resource data.
     */
    @JvmName("nhjtvjrxgrdhdnrc")
    public suspend fun resources(values: List<Output<ResourceMetadataArgs>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value Report collection trigger time's time zone, the available list can be obtained by executing "Get-TimeZone -ListAvailable" in PowerShell.
     * An example of valid timezone id is "Pacific Standard Time".
     */
    @JvmName("rbkgvduxxaptsbad")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Report collection trigger time.
     */
    @JvmName("tbbnkrjqyvcegxbs")
    public suspend fun triggerTime(`value`: Output<String>) {
        this.triggerTime = value
    }

    /**
     * @param value Report offer Guid.
     */
    @JvmName("cgimrlinysffnful")
    public suspend fun offerGuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerGuid = mapped
    }

    /**
     * @param value List of resource data.
     */
    @JvmName("xfmoywgccjfwfiod")
    public suspend fun resources(`value`: List<ResourceMetadataArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument List of resource data.
     */
    @JvmName("jwqrgxlliaoolvnj")
    public suspend fun resources(argument: List<suspend ResourceMetadataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceMetadataArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param argument List of resource data.
     */
    @JvmName("sdcctmphickmftvm")
    public suspend fun resources(vararg argument: suspend ResourceMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceMetadataArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param argument List of resource data.
     */
    @JvmName("ynlxngicwekhcajr")
    public suspend fun resources(argument: suspend ResourceMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceMetadataArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param values List of resource data.
     */
    @JvmName("arlxnaplgtflejkd")
    public suspend fun resources(vararg values: ResourceMetadataArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value Report collection trigger time's time zone, the available list can be obtained by executing "Get-TimeZone -ListAvailable" in PowerShell.
     * An example of valid timezone id is "Pacific Standard Time".
     */
    @JvmName("qqdataraiefdqxtd")
    public suspend fun timeZone(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value Report collection trigger time.
     */
    @JvmName("pmeehffgxwunxjdy")
    public suspend fun triggerTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerTime = mapped
    }

    internal fun build(): ReportPropertiesArgs = ReportPropertiesArgs(
        offerGuid = offerGuid,
        resources = resources ?: throw PulumiNullFieldException("resources"),
        timeZone = timeZone ?: throw PulumiNullFieldException("timeZone"),
        triggerTime = triggerTime ?: throw PulumiNullFieldException("triggerTime"),
    )
}
