@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs

import com.pulumi.azurenative.appcomplianceautomation.inputs.ResourceMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Single resource Id's metadata.
 * @property resourceId Resource Id - e.g. "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
 * @property resourceKind Resource kind.
 * @property resourceName Resource name.
 * @property resourceType Resource type.
 * @property tags Resource's tag type.
 */
public data class ResourceMetadataArgs(
    public val resourceId: Output<String>,
    public val resourceKind: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.inputs.ResourceMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.inputs.ResourceMetadataArgs =
        com.pulumi.azurenative.appcomplianceautomation.inputs.ResourceMetadataArgs.builder()
            .resourceId(resourceId.applyValue({ args0 -> args0 }))
            .resourceKind(resourceKind?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceMetadataArgs].
 */
@PulumiTagMarker
public class ResourceMetadataArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var resourceKind: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource Id - e.g. "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
     */
    @JvmName("jbvfwjrqelexoajd")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Resource kind.
     */
    @JvmName("pmwoncfmjwexgqns")
    public suspend fun resourceKind(`value`: Output<String>) {
        this.resourceKind = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("qedcppxheuywjytk")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource type.
     */
    @JvmName("epqmdajaupsnbxou")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Resource's tag type.
     */
    @JvmName("wcdpmqjmbqhjykrc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource Id - e.g. "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
     */
    @JvmName("oyodrjkpgpmwwpmn")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Resource kind.
     */
    @JvmName("veljxceuxtmvrgqf")
    public suspend fun resourceKind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceKind = mapped
    }

    /**
     * @param value Resource name.
     */
    @JvmName("qpiiufyhucjfebnw")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("vetrfnqpacijhobd")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Resource's tag type.
     */
    @JvmName("vsudjabumiurbyke")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource's tag type.
     */
    @JvmName("fxmugnonjgrxtpgo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceMetadataArgs = ResourceMetadataArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        resourceKind = resourceKind,
        resourceName = resourceName,
        resourceType = resourceType,
        tags = tags,
    )
}
