@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin

import com.pulumi.azurenative.appconfiguration.AppconfigurationFunctions.getConfigurationStorePlain
import com.pulumi.azurenative.appconfiguration.AppconfigurationFunctions.getKeyValuePlain
import com.pulumi.azurenative.appconfiguration.AppconfigurationFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.appconfiguration.AppconfigurationFunctions.getReplicaPlain
import com.pulumi.azurenative.appconfiguration.AppconfigurationFunctions.listConfigurationStoreKeysPlain
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.GetConfigurationStorePlainArgs
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.GetConfigurationStorePlainArgsBuilder
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.GetKeyValuePlainArgs
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.GetKeyValuePlainArgsBuilder
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.GetReplicaPlainArgs
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.GetReplicaPlainArgsBuilder
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.ListConfigurationStoreKeysPlainArgs
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.ListConfigurationStoreKeysPlainArgsBuilder
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.GetConfigurationStoreResult
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.GetKeyValueResult
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.GetReplicaResult
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.ListConfigurationStoreKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.GetConfigurationStoreResult.Companion.toKotlin as getConfigurationStoreResultToKotlin
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.GetKeyValueResult.Companion.toKotlin as getKeyValueResultToKotlin
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.GetReplicaResult.Companion.toKotlin as getReplicaResultToKotlin
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.ListConfigurationStoreKeysResult.Companion.toKotlin as listConfigurationStoreKeysResultToKotlin

public object AppconfigurationFunctions {
    /**
     * Gets the properties of the specified configuration store.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2019-02-01-preview, 2023-08-01-preview.
     * @param argument null
     * @return The configuration store along with all resource properties. The Configuration Store will have all information to begin utilizing it.
     */
    public suspend fun getConfigurationStore(argument: GetConfigurationStorePlainArgs):
        GetConfigurationStoreResult =
        getConfigurationStoreResultToKotlin(getConfigurationStorePlain(argument.toJava()).await())

    /**
     * @see [getConfigurationStore].
     * @param configStoreName The name of the configuration store.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @return The configuration store along with all resource properties. The Configuration Store will have all information to begin utilizing it.
     */
    public suspend fun getConfigurationStore(configStoreName: String, resourceGroupName: String):
        GetConfigurationStoreResult {
        val argument = GetConfigurationStorePlainArgs(
            configStoreName = configStoreName,
            resourceGroupName = resourceGroupName,
        )
        return getConfigurationStoreResultToKotlin(getConfigurationStorePlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationStore].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appconfiguration&#46;kotlin&#46;inputs&#46;GetConfigurationStorePlainArgs].
     * @return The configuration store along with all resource properties. The Configuration Store will have all information to begin utilizing it.
     */
    public suspend
    fun getConfigurationStore(argument: suspend GetConfigurationStorePlainArgsBuilder.() -> Unit):
        GetConfigurationStoreResult {
        val builder = GetConfigurationStorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationStoreResultToKotlin(getConfigurationStorePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified key-value. NOTE: This operation is intended for use in ARM Template deployments. For all other scenarios involving App Configuration key-values the data plane API should be used instead.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-08-01-preview.
     * @param argument null
     * @return The key-value resource along with all resource properties.
     */
    public suspend fun getKeyValue(argument: GetKeyValuePlainArgs): GetKeyValueResult =
        getKeyValueResultToKotlin(getKeyValuePlain(argument.toJava()).await())

    /**
     * @see [getKeyValue].
     * @param configStoreName The name of the configuration store.
     * @param keyValueName Identifier of key and label combination. Key and label are joined by $ character. Label is optional.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @return The key-value resource along with all resource properties.
     */
    public suspend fun getKeyValue(
        configStoreName: String,
        keyValueName: String,
        resourceGroupName: String,
    ): GetKeyValueResult {
        val argument = GetKeyValuePlainArgs(
            configStoreName = configStoreName,
            keyValueName = keyValueName,
            resourceGroupName = resourceGroupName,
        )
        return getKeyValueResultToKotlin(getKeyValuePlain(argument.toJava()).await())
    }

    /**
     * @see [getKeyValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appconfiguration&#46;kotlin&#46;inputs&#46;GetKeyValuePlainArgs].
     * @return The key-value resource along with all resource properties.
     */
    public suspend fun getKeyValue(argument: suspend GetKeyValuePlainArgsBuilder.() -> Unit):
        GetKeyValueResult {
        val builder = GetKeyValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyValueResultToKotlin(getKeyValuePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the configuration store.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-08-01-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param configStoreName The name of the configuration store.
     * @param privateEndpointConnectionName Private endpoint connection name
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        configStoreName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            configStoreName = configStoreName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appconfiguration&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified replica.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-08-01-preview.
     * @param argument null
     * @return The replica resource.
     */
    public suspend fun getReplica(argument: GetReplicaPlainArgs): GetReplicaResult =
        getReplicaResultToKotlin(getReplicaPlain(argument.toJava()).await())

    /**
     * @see [getReplica].
     * @param configStoreName The name of the configuration store.
     * @param replicaName The name of the replica.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @return The replica resource.
     */
    public suspend fun getReplica(
        configStoreName: String,
        replicaName: String,
        resourceGroupName: String,
    ): GetReplicaResult {
        val argument = GetReplicaPlainArgs(
            configStoreName = configStoreName,
            replicaName = replicaName,
            resourceGroupName = resourceGroupName,
        )
        return getReplicaResultToKotlin(getReplicaPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplica].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appconfiguration&#46;kotlin&#46;inputs&#46;GetReplicaPlainArgs].
     * @return The replica resource.
     */
    public suspend fun getReplica(argument: suspend GetReplicaPlainArgsBuilder.() -> Unit):
        GetReplicaResult {
        val builder = GetReplicaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicaResultToKotlin(getReplicaPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the access key for the specified configuration store.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2019-02-01-preview, 2023-08-01-preview.
     * @param argument null
     * @return The result of a request to list API keys.
     */
    public suspend fun listConfigurationStoreKeys(argument: ListConfigurationStoreKeysPlainArgs):
        ListConfigurationStoreKeysResult =
        listConfigurationStoreKeysResultToKotlin(listConfigurationStoreKeysPlain(argument.toJava()).await())

    /**
     * @see [listConfigurationStoreKeys].
     * @param configStoreName The name of the configuration store.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param skipToken A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies a starting point to use for subsequent calls.
     * @return The result of a request to list API keys.
     */
    public suspend fun listConfigurationStoreKeys(
        configStoreName: String,
        resourceGroupName: String,
        skipToken: String? = null,
    ): ListConfigurationStoreKeysResult {
        val argument = ListConfigurationStoreKeysPlainArgs(
            configStoreName = configStoreName,
            resourceGroupName = resourceGroupName,
            skipToken = skipToken,
        )
        return listConfigurationStoreKeysResultToKotlin(listConfigurationStoreKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listConfigurationStoreKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appconfiguration&#46;kotlin&#46;inputs&#46;ListConfigurationStoreKeysPlainArgs].
     * @return The result of a request to list API keys.
     */
    public suspend
    fun listConfigurationStoreKeys(argument: suspend ListConfigurationStoreKeysPlainArgsBuilder.() -> Unit):
        ListConfigurationStoreKeysResult {
        val builder = ListConfigurationStoreKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listConfigurationStoreKeysResultToKotlin(listConfigurationStoreKeysPlain(builtArgument.toJava()).await())
    }
}
