@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin

import com.pulumi.azurenative.appconfiguration.ConfigurationStoreArgs.builder
import com.pulumi.azurenative.appconfiguration.kotlin.enums.CreateMode
import com.pulumi.azurenative.appconfiguration.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.EncryptionPropertiesArgs
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.EncryptionPropertiesArgsBuilder
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.appconfiguration.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The configuration store along with all resource properties. The Configuration Store will have all information to begin utilizing it.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2019-02-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### ConfigurationStores_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationStore = new AzureNative.AppConfiguration.ConfigurationStore("configurationStore", new()
 *     {
 *         ConfigStoreName = "contoso",
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.AppConfiguration.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "myTag", "myTagValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfiguration.NewConfigurationStore(ctx, "configurationStore", &appconfiguration.ConfigurationStoreArgs{
 * 			ConfigStoreName:   pulumi.String("contoso"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &appconfiguration.SkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"myTag": pulumi.String("myTagValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appconfiguration.ConfigurationStore;
 * import com.pulumi.azurenative.appconfiguration.ConfigurationStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationStore = new ConfigurationStore("configurationStore", ConfigurationStoreArgs.builder()
 *             .configStoreName("contoso")
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "Standard"))
 *             .tags(Map.of("myTag", "myTagValue"))
 *             .build());
 *     }
 * }
 * ```
 * ### ConfigurationStores_Create_With_Local_Auth_Disabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationStore = new AzureNative.AppConfiguration.ConfigurationStore("configurationStore", new()
 *     {
 *         ConfigStoreName = "contoso",
 *         DisableLocalAuth = true,
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.AppConfiguration.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfiguration.NewConfigurationStore(ctx, "configurationStore", &appconfiguration.ConfigurationStoreArgs{
 * 			ConfigStoreName:   pulumi.String("contoso"),
 * 			DisableLocalAuth:  pulumi.Bool(true),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &appconfiguration.SkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appconfiguration.ConfigurationStore;
 * import com.pulumi.azurenative.appconfiguration.ConfigurationStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationStore = new ConfigurationStore("configurationStore", ConfigurationStoreArgs.builder()
 *             .configStoreName("contoso")
 *             .disableLocalAuth(true)
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appconfiguration:ConfigurationStore contoso /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}
 * ```
 * @property configStoreName The name of the configuration store.
 * @property createMode Indicates whether the configuration store need to be recovered.
 * @property disableLocalAuth Disables all authentication methods other than AAD authentication.
 * @property enablePurgeProtection Property specifying whether protection against purge is enabled for this configuration store.
 * @property encryption The encryption settings of the configuration store.
 * @property identity The managed identity information, if configured.
 * @property location The geo-location where the resource lives
 * @property publicNetworkAccess Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property sku The sku of the configuration store.
 * @property softDeleteRetentionInDays The amount of time in days that the configuration store will be retained when it is soft deleted.
 * @property tags Resource tags.
 */
public data class ConfigurationStoreArgs(
    public val configStoreName: Output<String>? = null,
    public val createMode: Output<CreateMode>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val enablePurgeProtection: Output<Boolean>? = null,
    public val encryption: Output<EncryptionPropertiesArgs>? = null,
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val softDeleteRetentionInDays: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.ConfigurationStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.appconfiguration.ConfigurationStoreArgs =
        com.pulumi.azurenative.appconfiguration.ConfigurationStoreArgs.builder()
            .configStoreName(configStoreName?.applyValue({ args0 -> args0 }))
            .createMode(createMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .enablePurgeProtection(enablePurgeProtection?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .softDeleteRetentionInDays(softDeleteRetentionInDays?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConfigurationStoreArgs].
 */
@PulumiTagMarker
public class ConfigurationStoreArgsBuilder internal constructor() {
    private var configStoreName: Output<String>? = null

    private var createMode: Output<CreateMode>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var enablePurgeProtection: Output<Boolean>? = null

    private var encryption: Output<EncryptionPropertiesArgs>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var softDeleteRetentionInDays: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("oacbnhbqdtdeywim")
    public suspend fun configStoreName(`value`: Output<String>) {
        this.configStoreName = value
    }

    /**
     * @param value Indicates whether the configuration store need to be recovered.
     */
    @JvmName("xhykgcfjjairwjbs")
    public suspend fun createMode(`value`: Output<CreateMode>) {
        this.createMode = value
    }

    /**
     * @param value Disables all authentication methods other than AAD authentication.
     */
    @JvmName("cdkwjratqbppuhnm")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Property specifying whether protection against purge is enabled for this configuration store.
     */
    @JvmName("xkmlntvmakbppuau")
    public suspend fun enablePurgeProtection(`value`: Output<Boolean>) {
        this.enablePurgeProtection = value
    }

    /**
     * @param value The encryption settings of the configuration store.
     */
    @JvmName("iykmramwqlnkvogg")
    public suspend fun encryption(`value`: Output<EncryptionPropertiesArgs>) {
        this.encryption = value
    }

    /**
     * @param value The managed identity information, if configured.
     */
    @JvmName("ujhajfeiteydqvqv")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ikcyvkrbuhcjslpk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    @JvmName("faglqjhnjjioyhxa")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("awglchmhhixmtwwh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku of the configuration store.
     */
    @JvmName("edgajicdnbiwcpmy")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The amount of time in days that the configuration store will be retained when it is soft deleted.
     */
    @JvmName("ceowxcetdpowkngn")
    public suspend fun softDeleteRetentionInDays(`value`: Output<Int>) {
        this.softDeleteRetentionInDays = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jebotpuqrvgjmtmg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("fwlesgsdmrlhducn")
    public suspend fun configStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configStoreName = mapped
    }

    /**
     * @param value Indicates whether the configuration store need to be recovered.
     */
    @JvmName("sxrpmgsvhymfwttj")
    public suspend fun createMode(`value`: CreateMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Disables all authentication methods other than AAD authentication.
     */
    @JvmName("ecjhdyvbvspxmbuh")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Property specifying whether protection against purge is enabled for this configuration store.
     */
    @JvmName("wlmgihigysesbffv")
    public suspend fun enablePurgeProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePurgeProtection = mapped
    }

    /**
     * @param value The encryption settings of the configuration store.
     */
    @JvmName("cpexfdskkdxaflvr")
    public suspend fun encryption(`value`: EncryptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The encryption settings of the configuration store.
     */
    @JvmName("lojucxytvucjvotm")
    public suspend fun encryption(argument: suspend EncryptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The managed identity information, if configured.
     */
    @JvmName("mlghnbvjgfklwvje")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identity information, if configured.
     */
    @JvmName("fyxskwndlagkyyka")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lriwvosrdggrhgqj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    @JvmName("qktcxcgvrbenwyfq")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    @JvmName("bxveputvqqpdlwxd")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    @JvmName("xdpkvuaxrmlnookq")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("qildrvymsnfyodsc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku of the configuration store.
     */
    @JvmName("eapxikcgintxwlfa")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku of the configuration store.
     */
    @JvmName("rrsahipluwgifict")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The amount of time in days that the configuration store will be retained when it is soft deleted.
     */
    @JvmName("qwmuyuhwebmcnvbs")
    public suspend fun softDeleteRetentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionInDays = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vqdkqucpjjdplfpj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vsmlfufseimlapqn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConfigurationStoreArgs = ConfigurationStoreArgs(
        configStoreName = configStoreName,
        createMode = createMode,
        disableLocalAuth = disableLocalAuth,
        enablePurgeProtection = enablePurgeProtection,
        encryption = encryption,
        identity = identity,
        location = location,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        sku = sku,
        softDeleteRetentionInDays = softDeleteRetentionInDays,
        tags = tags,
    )
}
