@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin

import com.pulumi.azurenative.appconfiguration.KeyValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The key-value resource along with all resource properties.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * Other available API versions: 2023-08-01-preview.
 * ## Example Usage
 * ### KeyValues_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var keyValue = new AzureNative.AppConfiguration.KeyValue("keyValue", new()
 *     {
 *         ConfigStoreName = "contoso",
 *         KeyValueName = "myKey$myLabel",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "tag1", "tagValue1" },
 *             { "tag2", "tagValue2" },
 *         },
 *         Value = "myValue",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfiguration.NewKeyValue(ctx, "keyValue", &appconfiguration.KeyValueArgs{
 * 			ConfigStoreName:   pulumi.String("contoso"),
 * 			KeyValueName:      pulumi.String("myKey$myLabel"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("tagValue1"),
 * 				"tag2": pulumi.String("tagValue2"),
 * 			},
 * 			Value: pulumi.String("myValue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appconfiguration.KeyValue;
 * import com.pulumi.azurenative.appconfiguration.KeyValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var keyValue = new KeyValue("keyValue", KeyValueArgs.builder()
 *             .configStoreName("contoso")
 *             .keyValueName("myKey$myLabel")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "tagValue1"),
 *                 Map.entry("tag2", "tagValue2")
 *             ))
 *             .value("myValue")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appconfiguration:KeyValue myKey$myLabel /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/keyValues/{keyValueName}
 * ```
 * @property configStoreName The name of the configuration store.
 * @property contentType The content type of the key-value's value.
 * Providing a proper content-type can enable transformations of values when they are retrieved by applications.
 * @property keyValueName Identifier of key and label combination. Key and label are joined by $ character. Label is optional.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property tags A dictionary of tags that can help identify what a key-value may be applicable for.
 * @property value The value of the key-value.
 */
public data class KeyValueArgs(
    public val configStoreName: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val keyValueName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.KeyValueArgs> {
    override fun toJava(): com.pulumi.azurenative.appconfiguration.KeyValueArgs =
        com.pulumi.azurenative.appconfiguration.KeyValueArgs.builder()
            .configStoreName(configStoreName?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .keyValueName(keyValueName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyValueArgs].
 */
@PulumiTagMarker
public class KeyValueArgsBuilder internal constructor() {
    private var configStoreName: Output<String>? = null

    private var contentType: Output<String>? = null

    private var keyValueName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("stvbxgjavnkdlush")
    public suspend fun configStoreName(`value`: Output<String>) {
        this.configStoreName = value
    }

    /**
     * @param value The content type of the key-value's value.
     * Providing a proper content-type can enable transformations of values when they are retrieved by applications.
     */
    @JvmName("gwogxbieotqgifrd")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Identifier of key and label combination. Key and label are joined by $ character. Label is optional.
     */
    @JvmName("jeopgxawrvlfjviv")
    public suspend fun keyValueName(`value`: Output<String>) {
        this.keyValueName = value
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("pmhpromobeudyrds")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A dictionary of tags that can help identify what a key-value may be applicable for.
     */
    @JvmName("gpajbwihfafeygtw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The value of the key-value.
     */
    @JvmName("egfdkvgvjbeslvta")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("suoslxfjoljckqon")
    public suspend fun configStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configStoreName = mapped
    }

    /**
     * @param value The content type of the key-value's value.
     * Providing a proper content-type can enable transformations of values when they are retrieved by applications.
     */
    @JvmName("sofvqurweeumhyvl")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Identifier of key and label combination. Key and label are joined by $ character. Label is optional.
     */
    @JvmName("soqofnunqjqvdgto")
    public suspend fun keyValueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyValueName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("yxubsrdgstniewnx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A dictionary of tags that can help identify what a key-value may be applicable for.
     */
    @JvmName("cryywjdioxwvaabw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A dictionary of tags that can help identify what a key-value may be applicable for.
     */
    @JvmName("irjwdxmtdnjufhdo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The value of the key-value.
     */
    @JvmName("cneuohwdpqbogknc")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): KeyValueArgs = KeyValueArgs(
        configStoreName = configStoreName,
        contentType = contentType,
        keyValueName = keyValueName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        `value` = `value`,
    )
}
