@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.inputs

import com.pulumi.azurenative.appconfiguration.inputs.EncryptionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The encryption settings for a configuration store.
 * @property keyVaultProperties Key vault properties.
 */
public data class EncryptionPropertiesArgs(
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.inputs.EncryptionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appconfiguration.inputs.EncryptionPropertiesArgs =
        com.pulumi.azurenative.appconfiguration.inputs.EncryptionPropertiesArgs.builder()
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesArgsBuilder internal constructor() {
    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    /**
     * @param value Key vault properties.
     */
    @JvmName("tsvpdfcsfbojjany")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Key vault properties.
     */
    @JvmName("pijbwvyqiboypwxo")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Key vault properties.
     */
    @JvmName("gyqcifnsykqdfnkt")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    internal fun build(): EncryptionPropertiesArgs = EncryptionPropertiesArgs(
        keyVaultProperties = keyVaultProperties,
    )
}
