@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.inputs

import com.pulumi.azurenative.appconfiguration.inputs.GetKeyValuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configStoreName The name of the configuration store.
 * @property keyValueName Identifier of key and label combination. Key and label are joined by $ character. Label is optional.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 */
public data class GetKeyValuePlainArgs(
    public val configStoreName: String,
    public val keyValueName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.inputs.GetKeyValuePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appconfiguration.inputs.GetKeyValuePlainArgs =
        com.pulumi.azurenative.appconfiguration.inputs.GetKeyValuePlainArgs.builder()
            .configStoreName(configStoreName.let({ args0 -> args0 }))
            .keyValueName(keyValueName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKeyValuePlainArgs].
 */
@PulumiTagMarker
public class GetKeyValuePlainArgsBuilder internal constructor() {
    private var configStoreName: String? = null

    private var keyValueName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("hdmpaltbrlowqhto")
    public suspend fun configStoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configStoreName = mapped
    }

    /**
     * @param value Identifier of key and label combination. Key and label are joined by $ character. Label is optional.
     */
    @JvmName("dtyretkefqooercd")
    public suspend fun keyValueName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyValueName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("jprkqwulsxmoxwku")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetKeyValuePlainArgs = GetKeyValuePlainArgs(
        configStoreName = configStoreName ?: throw PulumiNullFieldException("configStoreName"),
        keyValueName = keyValueName ?: throw PulumiNullFieldException("keyValueName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
