@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.inputs

import com.pulumi.azurenative.appconfiguration.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.appconfiguration.kotlin.enums.ConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The state of a private link service connection.
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val description: Output<String>? = null,
    public val status: Output<Either<String, ConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appconfiguration.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava():
        com.pulumi.azurenative.appconfiguration.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.appconfiguration.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var status: Output<Either<String, ConnectionStatus>>? = null

    /**
     * @param value The private link service connection description.
     */
    @JvmName("socyweakhommvogy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("efyyhcchbvoocint")
    public suspend fun status(`value`: Output<Either<String, ConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value The private link service connection description.
     */
    @JvmName("uqktmbmtauhcjtto")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("kfhifmlpiokrcnci")
    public suspend fun status(`value`: Either<String, ConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("dueurswcpugbbxdx")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("uaxrjmfmtempmngs")
    public fun status(`value`: ConnectionStatus) {
        val toBeMapped = Either.ofRight<String, ConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            description = description,
            status = status,
        )
}
