@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A reference to a related private endpoint connection.
 * @property id The resource ID.
 * @property name The name of the resource.
 * @property privateEndpoint The resource of private endpoint.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property provisioningState The provisioning status of the private endpoint connection.
 * @property type The type of the resource.
 */
public data class PrivateEndpointConnectionReferenceResponse(
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.outputs.PrivateEndpointConnectionReferenceResponse):
            PrivateEndpointConnectionReferenceResponse = PrivateEndpointConnectionReferenceResponse(
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appconfiguration.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                com.pulumi.azurenative.appconfiguration.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
