@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ApmPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.ApmPropertiesResponse.Companion.toKotlin as apmPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Apm].
 */
@PulumiTagMarker
public class ApmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApmArgs = ApmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApmArgsBuilder.() -> Unit) {
        val builder = ApmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Apm {
        val builtJavaResource = com.pulumi.azurenative.appplatform.Apm(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Apm(builtJavaResource)
    }
}

/**
 * APM Resource object
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Apms_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apm = new AzureNative.AppPlatform.Apm("apm", new()
 *     {
 *         ApmName = "myappinsights",
 *         Properties = new AzureNative.AppPlatform.Inputs.ApmPropertiesArgs
 *         {
 *             Properties =
 *             {
 *                 { "any-string", "any-string" },
 *                 { "sampling-rate", "12.0" },
 *             },
 *             Secrets =
 *             {
 *                 { "connection-string", "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX" },
 *             },
 *             Type = "ApplicationInsights",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewApm(ctx, "apm", &appplatform.ApmArgs{
 * 			ApmName: pulumi.String("myappinsights"),
 * 			Properties: &appplatform.ApmPropertiesArgs{
 * 				Properties: pulumi.StringMap{
 * 					"any-string":    pulumi.String("any-string"),
 * 					"sampling-rate": pulumi.String("12.0"),
 * 				},
 * 				Secrets: pulumi.StringMap{
 * 					"connection-string": pulumi.String("XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX"),
 * 				},
 * 				Type: pulumi.String("ApplicationInsights"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Apm;
 * import com.pulumi.azurenative.appplatform.ApmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apm = new Apm("apm", ApmArgs.builder()
 *             .apmName("myappinsights")
 *             .properties(Map.ofEntries(
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("any-string", "any-string"),
 *                     Map.entry("sampling-rate", "12.0")
 *                 )),
 *                 Map.entry("secrets", Map.of("connection-string", "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX")),
 *                 Map.entry("type", "ApplicationInsights")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Apm myappinsights /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apms/{apmName}
 * ```
 */
public class Apm internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.Apm,
) : KotlinCustomResource(javaResource, ApmMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of an APM
     */
    public val properties: Output<ApmPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                apmPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApmMapper : ResourceMapper<Apm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.Apm::class == javaResource::class

    override fun map(javaResource: Resource): Apm = Apm(
        javaResource as
            com.pulumi.azurenative.appplatform.Apm,
    )
}

/**
 * @see [Apm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Apm].
 */
public suspend fun apm(name: String, block: suspend ApmResourceBuilder.() -> Unit): Apm {
    val builder = ApmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Apm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apm(name: String): Apm {
    val builder = ApmResourceBuilder()
    builder.name(name)
    return builder.build()
}
