@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.ApmArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ApmPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ApmPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * APM Resource object
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Apms_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apm = new AzureNative.AppPlatform.Apm("apm", new()
 *     {
 *         ApmName = "myappinsights",
 *         Properties = new AzureNative.AppPlatform.Inputs.ApmPropertiesArgs
 *         {
 *             Properties =
 *             {
 *                 { "any-string", "any-string" },
 *                 { "sampling-rate", "12.0" },
 *             },
 *             Secrets =
 *             {
 *                 { "connection-string", "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX" },
 *             },
 *             Type = "ApplicationInsights",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewApm(ctx, "apm", &appplatform.ApmArgs{
 * 			ApmName: pulumi.String("myappinsights"),
 * 			Properties: &appplatform.ApmPropertiesArgs{
 * 				Properties: pulumi.StringMap{
 * 					"any-string":    pulumi.String("any-string"),
 * 					"sampling-rate": pulumi.String("12.0"),
 * 				},
 * 				Secrets: pulumi.StringMap{
 * 					"connection-string": pulumi.String("XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX"),
 * 				},
 * 				Type: pulumi.String("ApplicationInsights"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Apm;
 * import com.pulumi.azurenative.appplatform.ApmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apm = new Apm("apm", ApmArgs.builder()
 *             .apmName("myappinsights")
 *             .properties(Map.ofEntries(
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("any-string", "any-string"),
 *                     Map.entry("sampling-rate", "12.0")
 *                 )),
 *                 Map.entry("secrets", Map.of("connection-string", "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX")),
 *                 Map.entry("type", "ApplicationInsights")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Apm myappinsights /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apms/{apmName}
 * ```
 * @property apmName The name of the APM
 * @property properties Properties of an APM
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class ApmArgs(
    public val apmName: Output<String>? = null,
    public val properties: Output<ApmPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.ApmArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.ApmArgs =
        com.pulumi.azurenative.appplatform.ApmArgs.builder()
            .apmName(apmName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApmArgs].
 */
@PulumiTagMarker
public class ApmArgsBuilder internal constructor() {
    private var apmName: Output<String>? = null

    private var properties: Output<ApmPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the APM
     */
    @JvmName("liwfyghsexswojfj")
    public suspend fun apmName(`value`: Output<String>) {
        this.apmName = value
    }

    /**
     * @param value Properties of an APM
     */
    @JvmName("lksbujdswfyrejcb")
    public suspend fun properties(`value`: Output<ApmPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sriseccttgbxnvrm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("dufbcopxvtktclak")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the APM
     */
    @JvmName("mbbfomwufwenknfk")
    public suspend fun apmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apmName = mapped
    }

    /**
     * @param value Properties of an APM
     */
    @JvmName("tpppgwpndxpmhgfv")
    public suspend fun properties(`value`: ApmPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of an APM
     */
    @JvmName("ukjeqrcerrwemqsc")
    public suspend fun properties(argument: suspend ApmPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApmPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qjckqheqgwrqkcfu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("nhwxnufdtngpcxun")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ApmArgs = ApmArgs(
        apmName = apmName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
