@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.BindingResourcePropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.BindingResourcePropertiesResponse.Companion.toKotlin as bindingResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Binding].
 */
@PulumiTagMarker
public class BindingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BindingArgs = BindingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BindingArgsBuilder.() -> Unit) {
        val builder = BindingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Binding {
        val builtJavaResource = com.pulumi.azurenative.appplatform.Binding(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Binding(builtJavaResource)
    }
}

/**
 * Binding resource payload
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Bindings_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var binding = new AzureNative.AppPlatform.Binding("binding", new()
 *     {
 *         AppName = "myapp",
 *         BindingName = "mybinding",
 *         Properties = new AzureNative.AppPlatform.Inputs.BindingResourcePropertiesArgs
 *         {
 *             BindingParameters =
 *             {
 *                 { "apiType", "SQL" },
 *                 { "databaseName", "db1" },
 *             },
 *             Key = "xxxx",
 *             ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.DocumentDB/databaseAccounts/my-cosmosdb-1",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewBinding(ctx, "binding", &appplatform.BindingArgs{
 * 			AppName:     pulumi.String("myapp"),
 * 			BindingName: pulumi.String("mybinding"),
 * 			Properties: &appplatform.BindingResourcePropertiesArgs{
 * 				BindingParameters: pulumi.StringMap{
 * 					"apiType":      pulumi.String("SQL"),
 * 					"databaseName": pulumi.String("db1"),
 * 				},
 * 				Key:        pulumi.String("xxxx"),
 * 				ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.DocumentDB/databaseAccounts/my-cosmosdb-1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Binding;
 * import com.pulumi.azurenative.appplatform.BindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var binding = new Binding("binding", BindingArgs.builder()
 *             .appName("myapp")
 *             .bindingName("mybinding")
 *             .properties(Map.ofEntries(
 *                 Map.entry("bindingParameters", Map.ofEntries(
 *                     Map.entry("apiType", "SQL"),
 *                     Map.entry("databaseName", "db1")
 *                 )),
 *                 Map.entry("key", "xxxx"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.DocumentDB/databaseAccounts/my-cosmosdb-1")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Binding mybinding /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/bindings/{bindingName}
 * ```
 */
public class Binding internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.Binding,
) : KotlinCustomResource(javaResource, BindingMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the Binding resource
     */
    public val properties: Output<BindingResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                bindingResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BindingMapper : ResourceMapper<Binding> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.Binding::class == javaResource::class

    override fun map(javaResource: Resource): Binding = Binding(
        javaResource as
            com.pulumi.azurenative.appplatform.Binding,
    )
}

/**
 * @see [Binding].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Binding].
 */
public suspend fun binding(name: String, block: suspend BindingResourceBuilder.() -> Unit):
    Binding {
    val builder = BindingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Binding].
 * @param name The _unique_ name of the resulting resource.
 */
public fun binding(name: String): Binding {
    val builder = BindingResourceBuilder()
    builder.name(name)
    return builder.build()
}
