@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.BuildPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.BuildPropertiesResponse.Companion.toKotlin as buildPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BuildServiceBuild].
 */
@PulumiTagMarker
public class BuildServiceBuildResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BuildServiceBuildArgs = BuildServiceBuildArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BuildServiceBuildArgsBuilder.() -> Unit) {
        val builder = BuildServiceBuildArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BuildServiceBuild {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.BuildServiceBuild(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BuildServiceBuild(builtJavaResource)
    }
}

/**
 * Build resource payload
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### BuildService_CreateOrUpdateBuild
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var buildServiceBuild = new AzureNative.AppPlatform.BuildServiceBuild("buildServiceBuild", new()
 *     {
 *         BuildName = "mybuild",
 *         BuildServiceName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.BuildPropertiesArgs
 *         {
 *             AgentPool = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/buildServices/default/agentPools/default",
 *             Apms = new[]
 *             {
 *                 new AzureNative.AppPlatform.Inputs.ApmReferenceArgs
 *                 {
 *                     ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights",
 *                 },
 *             },
 *             Builder = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/buildServices/default/builders/default",
 *             Certificates = new[]
 *             {
 *                 new AzureNative.AppPlatform.Inputs.CertificateReferenceArgs
 *                 {
 *                     ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1",
 *                 },
 *                 new AzureNative.AppPlatform.Inputs.CertificateReferenceArgs
 *                 {
 *                     ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2",
 *                 },
 *             },
 *             Env =
 *             {
 *                 { "environmentVariable", "test" },
 *             },
 *             RelativePath = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855-20210601-3ed9f4a2-986b-4bbd-b833-a42dccb2f777",
 *             ResourceRequests = new AzureNative.AppPlatform.Inputs.BuildResourceRequestsArgs
 *             {
 *                 Cpu = "1",
 *                 Memory = "2Gi",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewBuildServiceBuild(ctx, "buildServiceBuild", &appplatform.BuildServiceBuildArgs{
 * 			BuildName:        pulumi.String("mybuild"),
 * 			BuildServiceName: pulumi.String("default"),
 * 			Properties: appplatform.BuildPropertiesResponse{
 * 				AgentPool: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/buildServices/default/agentPools/default"),
 * 				Apms: appplatform.ApmReferenceArray{
 * 					&appplatform.ApmReferenceArgs{
 * 						ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
 * 					},
 * 				},
 * 				Builder: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/buildServices/default/builders/default"),
 * 				Certificates: appplatform.CertificateReferenceArray{
 * 					&appplatform.CertificateReferenceArgs{
 * 						ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
 * 					},
 * 					&appplatform.CertificateReferenceArgs{
 * 						ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2"),
 * 					},
 * 				},
 * 				Env: pulumi.StringMap{
 * 					"environmentVariable": pulumi.String("test"),
 * 				},
 * 				RelativePath: pulumi.String("e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855-20210601-3ed9f4a2-986b-4bbd-b833-a42dccb2f777"),
 * 				ResourceRequests: &appplatform.BuildResourceRequestsArgs{
 * 					Cpu:    pulumi.String("1"),
 * 					Memory: pulumi.String("2Gi"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.BuildServiceBuild;
 * import com.pulumi.azurenative.appplatform.BuildServiceBuildArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var buildServiceBuild = new BuildServiceBuild("buildServiceBuild", BuildServiceBuildArgs.builder()
 *             .buildName("mybuild")
 *             .buildServiceName("default")
 *             .properties(Map.ofEntries(
 *                 Map.entry("agentPool", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/buildServices/default/agentPools/default"),
 *                 Map.entry("apms", Map.of("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights")),
 *                 Map.entry("builder", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/buildServices/default/builders/default"),
 *                 Map.entry("certificates",
 *                     Map.of("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1"),
 *                     Map.of("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2")),
 *                 Map.entry("env", Map.of("environmentVariable", "test")),
 *                 Map.entry("relativePath", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855-20210601-3ed9f4a2-986b-4bbd-b833-a42dccb2f777"),
 *                 Map.entry("resourceRequests", Map.ofEntries(
 *                     Map.entry("cpu", "1"),
 *                     Map.entry("memory", "2Gi")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:BuildServiceBuild mybuild /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}
 * ```
 */
public class BuildServiceBuild internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.BuildServiceBuild,
) : KotlinCustomResource(javaResource, BuildServiceBuildMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the build resource
     */
    public val properties: Output<BuildPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                buildPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BuildServiceBuildMapper : ResourceMapper<BuildServiceBuild> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.BuildServiceBuild::class == javaResource::class

    override fun map(javaResource: Resource): BuildServiceBuild = BuildServiceBuild(
        javaResource as
            com.pulumi.azurenative.appplatform.BuildServiceBuild,
    )
}

/**
 * @see [BuildServiceBuild].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BuildServiceBuild].
 */
public suspend fun buildServiceBuild(
    name: String,
    block: suspend BuildServiceBuildResourceBuilder.() -> Unit,
): BuildServiceBuild {
    val builder = BuildServiceBuildResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BuildServiceBuild].
 * @param name The _unique_ name of the resulting resource.
 */
public fun buildServiceBuild(name: String): BuildServiceBuild {
    val builder = BuildServiceBuildResourceBuilder()
    builder.name(name)
    return builder.build()
}
