@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.BuildServiceBuilderArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.BuilderPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.BuilderPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * KPack Builder resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### BuildServiceBuilder_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var buildServiceBuilder = new AzureNative.AppPlatform.BuildServiceBuilder("buildServiceBuilder", new()
 *     {
 *         BuildServiceName = "default",
 *         BuilderName = "mybuilder",
 *         Properties = new AzureNative.AppPlatform.Inputs.BuilderPropertiesArgs
 *         {
 *             BuildpackGroups = new[]
 *             {
 *                 new AzureNative.AppPlatform.Inputs.BuildpacksGroupPropertiesArgs
 *                 {
 *                     Buildpacks = new[]
 *                     {
 *                         new AzureNative.AppPlatform.Inputs.BuildpackPropertiesArgs
 *                         {
 *                             Id = "tanzu-buildpacks/java-azure",
 *                         },
 *                     },
 *                     Name = "mix",
 *                 },
 *             },
 *             Stack = new AzureNative.AppPlatform.Inputs.StackPropertiesArgs
 *             {
 *                 Id = "io.buildpacks.stacks.bionic",
 *                 Version = "base",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewBuildServiceBuilder(ctx, "buildServiceBuilder", &appplatform.BuildServiceBuilderArgs{
 * BuildServiceName: pulumi.String("default"),
 * BuilderName: pulumi.String("mybuilder"),
 * Properties: appplatform.BuilderPropertiesResponse{
 * BuildpackGroups: appplatform.BuildpacksGroupPropertiesArray{
 * interface{}{
 * Buildpacks: appplatform.BuildpackPropertiesArray{
 * &appplatform.BuildpackPropertiesArgs{
 * Id: pulumi.String("tanzu-buildpacks/java-azure"),
 * },
 * },
 * Name: pulumi.String("mix"),
 * },
 * },
 * Stack: &appplatform.StackPropertiesArgs{
 * Id: pulumi.String("io.buildpacks.stacks.bionic"),
 * Version: pulumi.String("base"),
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.BuildServiceBuilder;
 * import com.pulumi.azurenative.appplatform.BuildServiceBuilderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var buildServiceBuilder = new BuildServiceBuilder("buildServiceBuilder", BuildServiceBuilderArgs.builder()
 *             .buildServiceName("default")
 *             .builderName("mybuilder")
 *             .properties(Map.ofEntries(
 *                 Map.entry("buildpackGroups", Map.ofEntries(
 *                     Map.entry("buildpacks", Map.of("id", "tanzu-buildpacks/java-azure")),
 *                     Map.entry("name", "mix")
 *                 )),
 *                 Map.entry("stack", Map.ofEntries(
 *                     Map.entry("id", "io.buildpacks.stacks.bionic"),
 *                     Map.entry("version", "base")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:BuildServiceBuilder mybuilder /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}
 * ```
 * @property buildServiceName The name of the build service resource.
 * @property builderName The name of the builder resource.
 * @property properties Property of the Builder resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class BuildServiceBuilderArgs(
    public val buildServiceName: Output<String>? = null,
    public val builderName: Output<String>? = null,
    public val properties: Output<BuilderPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.BuildServiceBuilderArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.BuildServiceBuilderArgs =
        com.pulumi.azurenative.appplatform.BuildServiceBuilderArgs.builder()
            .buildServiceName(buildServiceName?.applyValue({ args0 -> args0 }))
            .builderName(builderName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildServiceBuilderArgs].
 */
@PulumiTagMarker
public class BuildServiceBuilderArgsBuilder internal constructor() {
    private var buildServiceName: Output<String>? = null

    private var builderName: Output<String>? = null

    private var properties: Output<BuilderPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("lfoftopfcvaydxga")
    public suspend fun buildServiceName(`value`: Output<String>) {
        this.buildServiceName = value
    }

    /**
     * @param value The name of the builder resource.
     */
    @JvmName("tvikovtufltlglqf")
    public suspend fun builderName(`value`: Output<String>) {
        this.builderName = value
    }

    /**
     * @param value Property of the Builder resource.
     */
    @JvmName("pphwonlppynyrrde")
    public suspend fun properties(`value`: Output<BuilderPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("uqhojcyeopxaetgl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("cjfkuhppqunslyhv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("awnukhllgbgvyscc")
    public suspend fun buildServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildServiceName = mapped
    }

    /**
     * @param value The name of the builder resource.
     */
    @JvmName("dpunhwdfblfopvwt")
    public suspend fun builderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.builderName = mapped
    }

    /**
     * @param value Property of the Builder resource.
     */
    @JvmName("frmfoakjhxigflwl")
    public suspend fun properties(`value`: BuilderPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Property of the Builder resource.
     */
    @JvmName("fbbxpmkhxybtherd")
    public suspend fun properties(argument: suspend BuilderPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BuilderPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("acswdytxiioxmcyn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("dpeaqjpmqdibxcml")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): BuildServiceBuilderArgs = BuildServiceBuilderArgs(
        buildServiceName = buildServiceName,
        builderName = builderName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
