@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ContentCertificatePropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.KeyVaultCertificatePropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.azurenative.appplatform.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * Certificate resource payload.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2021-06-01-preview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Certificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.AppPlatform.Certificate("certificate", new()
 *     {
 *         CertificateName = "mycertificate",
 *         Properties = new AzureNative.AppPlatform.Inputs.KeyVaultCertificatePropertiesArgs
 *         {
 *             CertVersion = "08a219d06d874795a96db47e06fbb01e",
 *             KeyVaultCertName = "mycert",
 *             Type = "KeyVaultCertificate",
 *             VaultUri = "https://myvault.vault.azure.net",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewCertificate(ctx, "certificate", &appplatform.CertificateArgs{
 * 			CertificateName: pulumi.String("mycertificate"),
 * 			Properties: appplatform.KeyVaultCertificateProperties{
 * 				CertVersion:      "08a219d06d874795a96db47e06fbb01e",
 * 				KeyVaultCertName: "mycert",
 * 				Type:             "KeyVaultCertificate",
 * 				VaultUri:         "https://myvault.vault.azure.net",
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Certificate;
 * import com.pulumi.azurenative.appplatform.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .certificateName("mycertificate")
 *             .properties(Map.ofEntries(
 *                 Map.entry("certVersion", "08a219d06d874795a96db47e06fbb01e"),
 *                 Map.entry("keyVaultCertName", "mycert"),
 *                 Map.entry("type", "KeyVaultCertificate"),
 *                 Map.entry("vaultUri", "https://myvault.vault.azure.net")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Certificate mycertificate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/certificates/{certificateName}
 * ```
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the certificate resource payload.
     */
    public val properties:
        Output<Either<ContentCertificatePropertiesResponse, KeyVaultCertificatePropertiesResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.appplatform.kotlin.outputs.ContentCertificatePropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.appplatform.kotlin.outputs.KeyVaultCertificatePropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.azurenative.appplatform.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit):
    Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
