@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.CustomizedAcceleratorArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.CustomizedAcceleratorPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.CustomizedAcceleratorPropertiesArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Customized accelerator resource
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CustomizedAccelerators_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customizedAccelerator = new AzureNative.AppPlatform.CustomizedAccelerator("customizedAccelerator", new()
 *     {
 *         ApplicationAcceleratorName = "default",
 *         CustomizedAcceleratorName = "acc-name",
 *         Properties = new AzureNative.AppPlatform.Inputs.CustomizedAcceleratorPropertiesArgs
 *         {
 *             AcceleratorTags = new[]
 *             {
 *                 "tag-a",
 *                 "tag-b",
 *             },
 *             Description = "acc-desc",
 *             DisplayName = "acc-name",
 *             GitRepository = new AzureNative.AppPlatform.Inputs.AcceleratorGitRepositoryArgs
 *             {
 *                 AuthSetting = new AzureNative.AppPlatform.Inputs.AcceleratorSshSettingArgs
 *                 {
 *                     AuthType = "SSH",
 *                     HostKey = "git-auth-hostkey",
 *                     HostKeyAlgorithm = "git-auth-algorithm",
 *                     PrivateKey = "git-auth-privatekey",
 *                 },
 *                 Branch = "git-branch",
 *                 Commit = "12345",
 *                 GitTag = "git-tag",
 *                 IntervalInSeconds = 70,
 *                 Url = "git-url",
 *             },
 *             IconUrl = "acc-icon",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewCustomizedAccelerator(ctx, "customizedAccelerator", &appplatform.CustomizedAcceleratorArgs{
 * 			ApplicationAcceleratorName: pulumi.String("default"),
 * 			CustomizedAcceleratorName:  pulumi.String("acc-name"),
 * 			Properties: appplatform.CustomizedAcceleratorPropertiesResponse{
 * 				AcceleratorTags: pulumi.StringArray{
 * 					pulumi.String("tag-a"),
 * 					pulumi.String("tag-b"),
 * 				},
 * 				Description: pulumi.String("acc-desc"),
 * 				DisplayName: pulumi.String("acc-name"),
 * 				GitRepository: &appplatform.AcceleratorGitRepositoryArgs{
 * 					AuthSetting: appplatform.AcceleratorSshSetting{
 * 						AuthType:         "SSH",
 * 						HostKey:          "git-auth-hostkey",
 * 						HostKeyAlgorithm: "git-auth-algorithm",
 * 						PrivateKey:       "git-auth-privatekey",
 * 					},
 * 					Branch:            pulumi.String("git-branch"),
 * 					Commit:            pulumi.String("12345"),
 * 					GitTag:            pulumi.String("git-tag"),
 * 					IntervalInSeconds: pulumi.Int(70),
 * 					Url:               pulumi.String("git-url"),
 * 				},
 * 				IconUrl: pulumi.String("acc-icon"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("E0"),
 * 				Tier:     pulumi.String("Enterprise"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.CustomizedAccelerator;
 * import com.pulumi.azurenative.appplatform.CustomizedAcceleratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customizedAccelerator = new CustomizedAccelerator("customizedAccelerator", CustomizedAcceleratorArgs.builder()
 *             .applicationAcceleratorName("default")
 *             .customizedAcceleratorName("acc-name")
 *             .properties(Map.ofEntries(
 *                 Map.entry("acceleratorTags",
 *                     "tag-a",
 *                     "tag-b"),
 *                 Map.entry("description", "acc-desc"),
 *                 Map.entry("displayName", "acc-name"),
 *                 Map.entry("gitRepository", Map.ofEntries(
 *                     Map.entry("authSetting", Map.ofEntries(
 *                         Map.entry("authType", "SSH"),
 *                         Map.entry("hostKey", "git-auth-hostkey"),
 *                         Map.entry("hostKeyAlgorithm", "git-auth-algorithm"),
 *                         Map.entry("privateKey", "git-auth-privatekey")
 *                     )),
 *                     Map.entry("branch", "git-branch"),
 *                     Map.entry("commit", "12345"),
 *                     Map.entry("gitTag", "git-tag"),
 *                     Map.entry("intervalInSeconds", 70),
 *                     Map.entry("url", "git-url")
 *                 )),
 *                 Map.entry("iconUrl", "acc-icon")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "E0"),
 *                 Map.entry("tier", "Enterprise")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:CustomizedAccelerator default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/customizedAccelerators/{customizedAcceleratorName}
 * ```
 * @property applicationAcceleratorName The name of the application accelerator.
 * @property customizedAcceleratorName The name of the customized accelerator.
 * @property properties Customized accelerator properties payload
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property sku Sku of the customized accelerator resource
 */
public data class CustomizedAcceleratorArgs(
    public val applicationAcceleratorName: Output<String>? = null,
    public val customizedAcceleratorName: Output<String>? = null,
    public val properties: Output<CustomizedAcceleratorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.CustomizedAcceleratorArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.CustomizedAcceleratorArgs =
        com.pulumi.azurenative.appplatform.CustomizedAcceleratorArgs.builder()
            .applicationAcceleratorName(applicationAcceleratorName?.applyValue({ args0 -> args0 }))
            .customizedAcceleratorName(customizedAcceleratorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomizedAcceleratorArgs].
 */
@PulumiTagMarker
public class CustomizedAcceleratorArgsBuilder internal constructor() {
    private var applicationAcceleratorName: Output<String>? = null

    private var customizedAcceleratorName: Output<String>? = null

    private var properties: Output<CustomizedAcceleratorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    /**
     * @param value The name of the application accelerator.
     */
    @JvmName("xlncokspebasdaao")
    public suspend fun applicationAcceleratorName(`value`: Output<String>) {
        this.applicationAcceleratorName = value
    }

    /**
     * @param value The name of the customized accelerator.
     */
    @JvmName("ogjqptwlnaflmdfn")
    public suspend fun customizedAcceleratorName(`value`: Output<String>) {
        this.customizedAcceleratorName = value
    }

    /**
     * @param value Customized accelerator properties payload
     */
    @JvmName("ncmhfdbqwvfyvjrw")
    public suspend fun properties(`value`: Output<CustomizedAcceleratorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ysitsuddlqcauodp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("lmysigjmnctwchxv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Sku of the customized accelerator resource
     */
    @JvmName("ydaqugkrofwrygbf")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of the application accelerator.
     */
    @JvmName("qhrabmcwjfadihxa")
    public suspend fun applicationAcceleratorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationAcceleratorName = mapped
    }

    /**
     * @param value The name of the customized accelerator.
     */
    @JvmName("jrcxkujblnepdxds")
    public suspend fun customizedAcceleratorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizedAcceleratorName = mapped
    }

    /**
     * @param value Customized accelerator properties payload
     */
    @JvmName("hbdekjdgghhjarjy")
    public suspend fun properties(`value`: CustomizedAcceleratorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Customized accelerator properties payload
     */
    @JvmName("hvscgfhpvapvkplp")
    public suspend
    fun properties(argument: suspend CustomizedAcceleratorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CustomizedAcceleratorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("eydhvnboefqwsnno")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("nirmmidunlonyqdg")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Sku of the customized accelerator resource
     */
    @JvmName("rlnkecuqfaisyotk")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku of the customized accelerator resource
     */
    @JvmName("adhqgddfnpygopov")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): CustomizedAcceleratorArgs = CustomizedAcceleratorArgs(
        applicationAcceleratorName = applicationAcceleratorName,
        customizedAcceleratorName = customizedAcceleratorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        sku = sku,
    )
}
