@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.DevToolPortalArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.DevToolPortalPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.DevToolPortalPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Dev Tool Portal resource
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### DevToolPortals_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devToolPortal = new AzureNative.AppPlatform.DevToolPortal("devToolPortal", new()
 *     {
 *         DevToolPortalName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.DevToolPortalPropertiesArgs
 *         {
 *             Features = new AzureNative.AppPlatform.Inputs.DevToolPortalFeatureSettingsArgs
 *             {
 *                 ApplicationAccelerator = new AzureNative.AppPlatform.Inputs.DevToolPortalFeatureDetailArgs
 *                 {
 *                     State = "Enabled",
 *                 },
 *                 ApplicationLiveView = new AzureNative.AppPlatform.Inputs.DevToolPortalFeatureDetailArgs
 *                 {
 *                     State = "Enabled",
 *                 },
 *             },
 *             Public = true,
 *             SsoProperties = new AzureNative.AppPlatform.Inputs.DevToolPortalSsoPropertiesArgs
 *             {
 *                 ClientId = "00000000-0000-0000-0000-000000000000",
 *                 ClientSecret = "xxxxx",
 *                 MetadataUrl = "https://login.microsoftonline.com/00000000-0000-0000-0000-000000000000/v2.0/.well-known/openid-configuration",
 *                 Scopes = new[]
 *                 {
 *                     "openid",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewDevToolPortal(ctx, "devToolPortal", &appplatform.DevToolPortalArgs{
 * DevToolPortalName: pulumi.String("default"),
 * Properties: appplatform.DevToolPortalPropertiesResponse{
 * Features: interface{}{
 * ApplicationAccelerator: &appplatform.DevToolPortalFeatureDetailArgs{
 * State: pulumi.String("Enabled"),
 * },
 * ApplicationLiveView: &appplatform.DevToolPortalFeatureDetailArgs{
 * State: pulumi.String("Enabled"),
 * },
 * },
 * Public: pulumi.Bool(true),
 * SsoProperties: &appplatform.DevToolPortalSsoPropertiesArgs{
 * ClientId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * ClientSecret: pulumi.String("xxxxx"),
 * MetadataUrl: pulumi.String("https://login.microsoftonline.com/00000000-0000-0000-0000-000000000000/v2.0/.well-known/openid-configuration"),
 * Scopes: pulumi.StringArray{
 * pulumi.String("openid"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.DevToolPortal;
 * import com.pulumi.azurenative.appplatform.DevToolPortalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devToolPortal = new DevToolPortal("devToolPortal", DevToolPortalArgs.builder()
 *             .devToolPortalName("default")
 *             .properties(Map.ofEntries(
 *                 Map.entry("features", Map.ofEntries(
 *                     Map.entry("applicationAccelerator", Map.of("state", "Enabled")),
 *                     Map.entry("applicationLiveView", Map.of("state", "Enabled"))
 *                 )),
 *                 Map.entry("public", true),
 *                 Map.entry("ssoProperties", Map.ofEntries(
 *                     Map.entry("clientId", "00000000-0000-0000-0000-000000000000"),
 *                     Map.entry("clientSecret", "xxxxx"),
 *                     Map.entry("metadataUrl", "https://login.microsoftonline.com/00000000-0000-0000-0000-000000000000/v2.0/.well-known/openid-configuration"),
 *                     Map.entry("scopes", "openid")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:DevToolPortal default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/DevToolPortals/{devToolPortalName}
 * ```
 * @property devToolPortalName The name of Dev Tool Portal.
 * @property properties Dev Tool Portal properties payload
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class DevToolPortalArgs(
    public val devToolPortalName: Output<String>? = null,
    public val properties: Output<DevToolPortalPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.DevToolPortalArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.DevToolPortalArgs =
        com.pulumi.azurenative.appplatform.DevToolPortalArgs.builder()
            .devToolPortalName(devToolPortalName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevToolPortalArgs].
 */
@PulumiTagMarker
public class DevToolPortalArgsBuilder internal constructor() {
    private var devToolPortalName: Output<String>? = null

    private var properties: Output<DevToolPortalPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of Dev Tool Portal.
     */
    @JvmName("gfouskgpgfnwedxe")
    public suspend fun devToolPortalName(`value`: Output<String>) {
        this.devToolPortalName = value
    }

    /**
     * @param value Dev Tool Portal properties payload
     */
    @JvmName("ycvdivbsxckhnnds")
    public suspend fun properties(`value`: Output<DevToolPortalPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tjyjoreergsqaxks")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("gajwfydlbcvnyncc")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of Dev Tool Portal.
     */
    @JvmName("xpnaeqvuflgitrjn")
    public suspend fun devToolPortalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devToolPortalName = mapped
    }

    /**
     * @param value Dev Tool Portal properties payload
     */
    @JvmName("cusjreevglghvnus")
    public suspend fun properties(`value`: DevToolPortalPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Dev Tool Portal properties payload
     */
    @JvmName("cskntlymdnsiusou")
    public suspend fun properties(argument: suspend DevToolPortalPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DevToolPortalPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hyiggbqqrcsnmlke")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("lxvfxplbkhqqflyb")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): DevToolPortalArgs = DevToolPortalArgs(
        devToolPortalName = devToolPortalName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
