@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.GatewayArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GatewayPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GatewayPropertiesArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Spring Cloud Gateway resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Gateways_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gateway = new AzureNative.AppPlatform.Gateway("gateway", new()
 *     {
 *         GatewayName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.GatewayPropertiesArgs
 *         {
 *             Public = true,
 *             ResourceRequests = new AzureNative.AppPlatform.Inputs.GatewayResourceRequestsArgs
 *             {
 *                 Cpu = "1",
 *                 Memory = "1G",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewGateway(ctx, "gateway", &appplatform.GatewayArgs{
 * 			GatewayName: pulumi.String("default"),
 * 			Properties: appplatform.GatewayPropertiesResponse{
 * 				Public: pulumi.Bool(true),
 * 				ResourceRequests: &appplatform.GatewayResourceRequestsArgs{
 * 					Cpu:    pulumi.String("1"),
 * 					Memory: pulumi.String("1G"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("E0"),
 * 				Tier:     pulumi.String("Enterprise"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Gateway;
 * import com.pulumi.azurenative.appplatform.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gateway = new Gateway("gateway", GatewayArgs.builder()
 *             .gatewayName("default")
 *             .properties(Map.ofEntries(
 *                 Map.entry("public", true),
 *                 Map.entry("resourceRequests", Map.ofEntries(
 *                     Map.entry("cpu", "1"),
 *                     Map.entry("memory", "1G")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "E0"),
 *                 Map.entry("tier", "Enterprise")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Gateway default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}
 * ```
 * @property gatewayName The name of Spring Cloud Gateway.
 * @property properties Spring Cloud Gateway properties payload
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property sku Sku of the Spring Cloud Gateway resource
 */
public data class GatewayArgs(
    public val gatewayName: Output<String>? = null,
    public val properties: Output<GatewayPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.GatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.GatewayArgs =
        com.pulumi.azurenative.appplatform.GatewayArgs.builder()
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var gatewayName: Output<String>? = null

    private var properties: Output<GatewayPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    /**
     * @param value The name of Spring Cloud Gateway.
     */
    @JvmName("semlmmmaqoreskys")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value Spring Cloud Gateway properties payload
     */
    @JvmName("nklqgthwoluourvp")
    public suspend fun properties(`value`: Output<GatewayPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("cocgkuqqwyceurht")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("kuhygkjxnbwnoxnw")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Sku of the Spring Cloud Gateway resource
     */
    @JvmName("evgmtoeunijeosfm")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of Spring Cloud Gateway.
     */
    @JvmName("wadoenhvoxmxygyt")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value Spring Cloud Gateway properties payload
     */
    @JvmName("rssugqkwionkntll")
    public suspend fun properties(`value`: GatewayPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Spring Cloud Gateway properties payload
     */
    @JvmName("ckywejyubyyagqxf")
    public suspend fun properties(argument: suspend GatewayPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vcvdvjaeuygjnbkx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("klpsqmgkdcptucpn")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Sku of the Spring Cloud Gateway resource
     */
    @JvmName("ptcesptxredqvcso")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku of the Spring Cloud Gateway resource
     */
    @JvmName("ocoewrqymscbsbhc")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        gatewayName = gatewayName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        sku = sku,
    )
}
