@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.ServiceRegistryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Service Registry resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### ServiceRegistries_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceRegistry = new AzureNative.AppPlatform.ServiceRegistry("serviceRegistry", new()
 *     {
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         ServiceRegistryName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewServiceRegistry(ctx, "serviceRegistry", &appplatform.ServiceRegistryArgs{
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceName:         pulumi.String("myservice"),
 * 			ServiceRegistryName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ServiceRegistry;
 * import com.pulumi.azurenative.appplatform.ServiceRegistryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceRegistry = new ServiceRegistry("serviceRegistry", ServiceRegistryArgs.builder()
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .serviceRegistryName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ServiceRegistry default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/serviceRegistries/{serviceRegistryName}
 * ```
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property serviceRegistryName The name of Service Registry.
 */
public data class ServiceRegistryArgs(
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceRegistryName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.ServiceRegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.ServiceRegistryArgs =
        com.pulumi.azurenative.appplatform.ServiceRegistryArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceRegistryName(serviceRegistryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceRegistryArgs].
 */
@PulumiTagMarker
public class ServiceRegistryArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var serviceRegistryName: Output<String>? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ijxlsvadomvkfqll")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("bkugywsbccbljxmw")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of Service Registry.
     */
    @JvmName("goajfetrvdnafalp")
    public suspend fun serviceRegistryName(`value`: Output<String>) {
        this.serviceRegistryName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tsdjcrmqyjsqhlqq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("quberodqeoprxxwt")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The name of Service Registry.
     */
    @JvmName("yvptayvkvhshddtg")
    public suspend fun serviceRegistryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRegistryName = mapped
    }

    internal fun build(): ServiceRegistryArgs = ServiceRegistryArgs(
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        serviceRegistryName = serviceRegistryName,
    )
}
