@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.AcceleratorSshSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auth setting for SSH auth.
 * @property authType The type of the auth setting.
 * Expected value is 'SSH'.
 * @property hostKey Public SSH Key of git repository.
 * @property hostKeyAlgorithm SSH Key algorithm of git repository.
 * @property privateKey Private SSH Key algorithm of git repository.
 */
public data class AcceleratorSshSettingArgs(
    public val authType: Output<String>,
    public val hostKey: Output<String>? = null,
    public val hostKeyAlgorithm: Output<String>? = null,
    public val privateKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.AcceleratorSshSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.AcceleratorSshSettingArgs =
        com.pulumi.azurenative.appplatform.inputs.AcceleratorSshSettingArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .hostKey(hostKey?.applyValue({ args0 -> args0 }))
            .hostKeyAlgorithm(hostKeyAlgorithm?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AcceleratorSshSettingArgs].
 */
@PulumiTagMarker
public class AcceleratorSshSettingArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var hostKey: Output<String>? = null

    private var hostKeyAlgorithm: Output<String>? = null

    private var privateKey: Output<String>? = null

    /**
     * @param value The type of the auth setting.
     * Expected value is 'SSH'.
     */
    @JvmName("txtpiyrnarqxjhrb")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Public SSH Key of git repository.
     */
    @JvmName("vcrlteabwjbtnmuj")
    public suspend fun hostKey(`value`: Output<String>) {
        this.hostKey = value
    }

    /**
     * @param value SSH Key algorithm of git repository.
     */
    @JvmName("wxjtuxdafgidrkub")
    public suspend fun hostKeyAlgorithm(`value`: Output<String>) {
        this.hostKeyAlgorithm = value
    }

    /**
     * @param value Private SSH Key algorithm of git repository.
     */
    @JvmName("rqwgkqvjpnrpgtrt")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value The type of the auth setting.
     * Expected value is 'SSH'.
     */
    @JvmName("wkwxdoxxsthgqvti")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Public SSH Key of git repository.
     */
    @JvmName("kftklschcubdltrn")
    public suspend fun hostKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKey = mapped
    }

    /**
     * @param value SSH Key algorithm of git repository.
     */
    @JvmName("gekbxtsipfstjdhp")
    public suspend fun hostKeyAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKeyAlgorithm = mapped
    }

    /**
     * @param value Private SSH Key algorithm of git repository.
     */
    @JvmName("soydrmaniajvjpfb")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    internal fun build(): AcceleratorSshSettingArgs = AcceleratorSshSettingArgs(
        authType = authType ?: throw PulumiNullFieldException("authType"),
        hostKey = hostKey,
        hostKeyAlgorithm = hostKeyAlgorithm,
        privateKey = privateKey,
    )
}
