@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Build resource properties payload
 * @property agentPool The resource id of agent pool
 * @property apms The APMs for this build
 * @property builder The resource id of builder to build the source code
 * @property certificates The CA Certificates for this build
 * @property env The environment variables for this build
 * @property relativePath The relative path of source code
 * @property resourceRequests The customized build resource for this build
 */
public data class BuildPropertiesArgs(
    public val agentPool: Output<String>? = null,
    public val apms: Output<List<ApmReferenceArgs>>? = null,
    public val builder: Output<String>? = null,
    public val certificates: Output<List<CertificateReferenceArgs>>? = null,
    public val env: Output<Map<String, String>>? = null,
    public val relativePath: Output<String>? = null,
    public val resourceRequests: Output<BuildResourceRequestsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.BuildPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildPropertiesArgs.builder()
            .agentPool(agentPool?.applyValue({ args0 -> args0 }))
            .apms(apms?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .builder_(builder?.applyValue({ args0 -> args0 }))
            .certificates(
                certificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .env(env?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .relativePath(relativePath?.applyValue({ args0 -> args0 }))
            .resourceRequests(
                resourceRequests?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BuildPropertiesArgs].
 */
@PulumiTagMarker
public class BuildPropertiesArgsBuilder internal constructor() {
    private var agentPool: Output<String>? = null

    private var apms: Output<List<ApmReferenceArgs>>? = null

    private var builder: Output<String>? = null

    private var certificates: Output<List<CertificateReferenceArgs>>? = null

    private var env: Output<Map<String, String>>? = null

    private var relativePath: Output<String>? = null

    private var resourceRequests: Output<BuildResourceRequestsArgs>? = null

    /**
     * @param value The resource id of agent pool
     */
    @JvmName("hwelkbqwowolncmq")
    public suspend fun agentPool(`value`: Output<String>) {
        this.agentPool = value
    }

    /**
     * @param value The APMs for this build
     */
    @JvmName("dnilklomsoraeshj")
    public suspend fun apms(`value`: Output<List<ApmReferenceArgs>>) {
        this.apms = value
    }

    @JvmName("qjinlsabalhrvjio")
    public suspend fun apms(vararg values: Output<ApmReferenceArgs>) {
        this.apms = Output.all(values.asList())
    }

    /**
     * @param values The APMs for this build
     */
    @JvmName("wbmxjebyqvxftadw")
    public suspend fun apms(values: List<Output<ApmReferenceArgs>>) {
        this.apms = Output.all(values)
    }

    /**
     * @param value The resource id of builder to build the source code
     */
    @JvmName("pnfwgwisdiuntyeh")
    public suspend fun builder(`value`: Output<String>) {
        this.builder = value
    }

    /**
     * @param value The CA Certificates for this build
     */
    @JvmName("ihrdulgrpfscqcff")
    public suspend fun certificates(`value`: Output<List<CertificateReferenceArgs>>) {
        this.certificates = value
    }

    @JvmName("vxxdswfaxigsgqpq")
    public suspend fun certificates(vararg values: Output<CertificateReferenceArgs>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values The CA Certificates for this build
     */
    @JvmName("tyjnxrsisiompakn")
    public suspend fun certificates(values: List<Output<CertificateReferenceArgs>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value The environment variables for this build
     */
    @JvmName("ydpitxecelevpahu")
    public suspend fun env(`value`: Output<Map<String, String>>) {
        this.env = value
    }

    /**
     * @param value The relative path of source code
     */
    @JvmName("ddvmvwgvhspdnrub")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value The customized build resource for this build
     */
    @JvmName("dlvrtfjviwlcqjff")
    public suspend fun resourceRequests(`value`: Output<BuildResourceRequestsArgs>) {
        this.resourceRequests = value
    }

    /**
     * @param value The resource id of agent pool
     */
    @JvmName("vtvfmcndjnvqnnnt")
    public suspend fun agentPool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPool = mapped
    }

    /**
     * @param value The APMs for this build
     */
    @JvmName("onfobiyvksvcewwl")
    public suspend fun apms(`value`: List<ApmReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apms = mapped
    }

    /**
     * @param argument The APMs for this build
     */
    @JvmName("rnmqnuklbxhssplg")
    public suspend fun apms(argument: List<suspend ApmReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApmReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apms = mapped
    }

    /**
     * @param argument The APMs for this build
     */
    @JvmName("uioqfxbaqtbeubto")
    public suspend fun apms(vararg argument: suspend ApmReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApmReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apms = mapped
    }

    /**
     * @param argument The APMs for this build
     */
    @JvmName("ebgbjydkuqfefuky")
    public suspend fun apms(argument: suspend ApmReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApmReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.apms = mapped
    }

    /**
     * @param values The APMs for this build
     */
    @JvmName("vqrfhvdytqleruue")
    public suspend fun apms(vararg values: ApmReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apms = mapped
    }

    /**
     * @param value The resource id of builder to build the source code
     */
    @JvmName("iwocongmviomsfoy")
    public suspend fun builder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.builder = mapped
    }

    /**
     * @param value The CA Certificates for this build
     */
    @JvmName("rxbbvocleqthmeds")
    public suspend fun certificates(`value`: List<CertificateReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param argument The CA Certificates for this build
     */
    @JvmName("tplmrgopyuycakcr")
    public suspend
    fun certificates(argument: List<suspend CertificateReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CertificateReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument The CA Certificates for this build
     */
    @JvmName("eoyttgsaopdlylke")
    public suspend fun certificates(
        vararg
        argument: suspend CertificateReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CertificateReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument The CA Certificates for this build
     */
    @JvmName("nwqdukuffonsaeem")
    public suspend fun certificates(argument: suspend CertificateReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CertificateReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param values The CA Certificates for this build
     */
    @JvmName("vqnrwybrxnigkxvr")
    public suspend fun certificates(vararg values: CertificateReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value The environment variables for this build
     */
    @JvmName("nfsyqfpsygsfyuna")
    public suspend fun env(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param values The environment variables for this build
     */
    @JvmName("nwoeydfforxlrqsa")
    public fun env(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param value The relative path of source code
     */
    @JvmName("qgdypiqimbfgnwgb")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    /**
     * @param value The customized build resource for this build
     */
    @JvmName("tropkqnwhehsvkor")
    public suspend fun resourceRequests(`value`: BuildResourceRequestsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRequests = mapped
    }

    /**
     * @param argument The customized build resource for this build
     */
    @JvmName("qirpljoxhybxrvmu")
    public suspend
    fun resourceRequests(argument: suspend BuildResourceRequestsArgsBuilder.() -> Unit) {
        val toBeMapped = BuildResourceRequestsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceRequests = mapped
    }

    internal fun build(): BuildPropertiesArgs = BuildPropertiesArgs(
        agentPool = agentPool,
        apms = apms,
        builder = builder,
        certificates = certificates,
        env = env,
        relativePath = relativePath,
        resourceRequests = resourceRequests,
    )
}
