@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildResultUserSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to a build result
 * @property buildResultId Resource id of an existing succeeded build result under the same Spring instance.
 * @property type Type of the source uploaded
 * Expected value is 'BuildResult'.
 * @property version Version of the source
 */
public data class BuildResultUserSourceInfoArgs(
    public val buildResultId: Output<String>? = null,
    public val type: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildResultUserSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.BuildResultUserSourceInfoArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildResultUserSourceInfoArgs.builder()
            .buildResultId(buildResultId?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildResultUserSourceInfoArgs].
 */
@PulumiTagMarker
public class BuildResultUserSourceInfoArgsBuilder internal constructor() {
    private var buildResultId: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Resource id of an existing succeeded build result under the same Spring instance.
     */
    @JvmName("qpjjbeqvjjwkgxhp")
    public suspend fun buildResultId(`value`: Output<String>) {
        this.buildResultId = value
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'BuildResult'.
     */
    @JvmName("guyevkhiaruaqqas")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Version of the source
     */
    @JvmName("dnfqpleeljjkykil")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Resource id of an existing succeeded build result under the same Spring instance.
     */
    @JvmName("frxkllptdnqifumv")
    public suspend fun buildResultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildResultId = mapped
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'BuildResult'.
     */
    @JvmName("cqxqgycvueasfbww")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Version of the source
     */
    @JvmName("xedifxmfhxflcbdr")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): BuildResultUserSourceInfoArgs = BuildResultUserSourceInfoArgs(
        buildResultId = buildResultId,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
