@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildpackBindingPropertiesArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.BindingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of a buildpack binding
 * @property bindingType Buildpack Binding Type
 * @property launchProperties The object describes the buildpack binding launch properties
 */
public data class BuildpackBindingPropertiesArgs(
    public val bindingType: Output<Either<String, BindingType>>? = null,
    public val launchProperties: Output<BuildpackBindingLaunchPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildpackBindingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.BuildpackBindingPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildpackBindingPropertiesArgs.builder()
            .bindingType(
                bindingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchProperties(
                launchProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BuildpackBindingPropertiesArgs].
 */
@PulumiTagMarker
public class BuildpackBindingPropertiesArgsBuilder internal constructor() {
    private var bindingType: Output<Either<String, BindingType>>? = null

    private var launchProperties: Output<BuildpackBindingLaunchPropertiesArgs>? = null

    /**
     * @param value Buildpack Binding Type
     */
    @JvmName("wgqwlctvhulcyssi")
    public suspend fun bindingType(`value`: Output<Either<String, BindingType>>) {
        this.bindingType = value
    }

    /**
     * @param value The object describes the buildpack binding launch properties
     */
    @JvmName("drghlyvsidplsynl")
    public suspend fun launchProperties(`value`: Output<BuildpackBindingLaunchPropertiesArgs>) {
        this.launchProperties = value
    }

    /**
     * @param value Buildpack Binding Type
     */
    @JvmName("bsnslxriygohqnlf")
    public suspend fun bindingType(`value`: Either<String, BindingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindingType = mapped
    }

    /**
     * @param value Buildpack Binding Type
     */
    @JvmName("utwymevswmyeaqlu")
    public fun bindingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BindingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindingType = mapped
    }

    /**
     * @param value Buildpack Binding Type
     */
    @JvmName("udmdfcuufjfhhera")
    public fun bindingType(`value`: BindingType) {
        val toBeMapped = Either.ofRight<String, BindingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindingType = mapped
    }

    /**
     * @param value The object describes the buildpack binding launch properties
     */
    @JvmName("isvfqyetelqbojqy")
    public suspend fun launchProperties(`value`: BuildpackBindingLaunchPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchProperties = mapped
    }

    /**
     * @param argument The object describes the buildpack binding launch properties
     */
    @JvmName("etynbnfihklijpsj")
    public suspend
    fun launchProperties(argument: suspend BuildpackBindingLaunchPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BuildpackBindingLaunchPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchProperties = mapped
    }

    internal fun build(): BuildpackBindingPropertiesArgs = BuildpackBindingPropertiesArgs(
        bindingType = bindingType,
        launchProperties = launchProperties,
    )
}
