@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ConfigServerSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The settings of config server.
 * @property gitProperty Property of git environment.
 */
public data class ConfigServerSettingsArgs(
    public val gitProperty: Output<ConfigServerGitPropertyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ConfigServerSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ConfigServerSettingsArgs =
        com.pulumi.azurenative.appplatform.inputs.ConfigServerSettingsArgs.builder()
            .gitProperty(gitProperty?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigServerSettingsArgs].
 */
@PulumiTagMarker
public class ConfigServerSettingsArgsBuilder internal constructor() {
    private var gitProperty: Output<ConfigServerGitPropertyArgs>? = null

    /**
     * @param value Property of git environment.
     */
    @JvmName("iutysghgcfbltknv")
    public suspend fun gitProperty(`value`: Output<ConfigServerGitPropertyArgs>) {
        this.gitProperty = value
    }

    /**
     * @param value Property of git environment.
     */
    @JvmName("olgretsxmtbhpldb")
    public suspend fun gitProperty(`value`: ConfigServerGitPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitProperty = mapped
    }

    /**
     * @param argument Property of git environment.
     */
    @JvmName("uqucoknowrjbtihe")
    public suspend fun gitProperty(argument: suspend ConfigServerGitPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigServerGitPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitProperty = mapped
    }

    internal fun build(): ConfigServerSettingsArgs = ConfigServerSettingsArgs(
        gitProperty = gitProperty,
    )
}
