@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ConfigurationServicePropertiesArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.ConfigurationServiceGeneration
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Application Configuration Service properties payload
 * @property generation The generation of the Application Configuration Service.
 * @property settings The settings of Application Configuration Service.
 */
public data class ConfigurationServicePropertiesArgs(
    public val generation: Output<Either<String, ConfigurationServiceGeneration>>? = null,
    public val settings: Output<ConfigurationServiceSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ConfigurationServicePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.appplatform.inputs.ConfigurationServicePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.ConfigurationServicePropertiesArgs.builder()
            .generation(
                generation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigurationServicePropertiesArgs].
 */
@PulumiTagMarker
public class ConfigurationServicePropertiesArgsBuilder internal constructor() {
    private var generation: Output<Either<String, ConfigurationServiceGeneration>>? = null

    private var settings: Output<ConfigurationServiceSettingsArgs>? = null

    /**
     * @param value The generation of the Application Configuration Service.
     */
    @JvmName("ylbfgxyesponljug")
    public suspend fun generation(`value`: Output<Either<String, ConfigurationServiceGeneration>>) {
        this.generation = value
    }

    /**
     * @param value The settings of Application Configuration Service.
     */
    @JvmName("ilkdekiklrxyokfe")
    public suspend fun settings(`value`: Output<ConfigurationServiceSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value The generation of the Application Configuration Service.
     */
    @JvmName("lytuwceubpguoocg")
    public suspend fun generation(`value`: Either<String, ConfigurationServiceGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generation = mapped
    }

    /**
     * @param value The generation of the Application Configuration Service.
     */
    @JvmName("toskfsvhmffhbxtu")
    public fun generation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfigurationServiceGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.generation = mapped
    }

    /**
     * @param value The generation of the Application Configuration Service.
     */
    @JvmName("lkdfunxstnfvwbpm")
    public fun generation(`value`: ConfigurationServiceGeneration) {
        val toBeMapped = Either.ofRight<String, ConfigurationServiceGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.generation = mapped
    }

    /**
     * @param value The settings of Application Configuration Service.
     */
    @JvmName("ownqqapsicrvddge")
    public suspend fun settings(`value`: ConfigurationServiceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument The settings of Application Configuration Service.
     */
    @JvmName("ntufjdqcrldebljy")
    public suspend
    fun settings(argument: suspend ConfigurationServiceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationServiceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    internal fun build(): ConfigurationServicePropertiesArgs = ConfigurationServicePropertiesArgs(
        generation = generation,
        settings = settings,
    )
}
