@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayCustomDomainPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of custom domain for Spring Cloud Gateway
 * @property thumbprint The thumbprint of bound certificate.
 */
public data class GatewayCustomDomainPropertiesArgs(
    public val thumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayCustomDomainPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GatewayCustomDomainPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayCustomDomainPropertiesArgs.builder()
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayCustomDomainPropertiesArgs].
 */
@PulumiTagMarker
public class GatewayCustomDomainPropertiesArgsBuilder internal constructor() {
    private var thumbprint: Output<String>? = null

    /**
     * @param value The thumbprint of bound certificate.
     */
    @JvmName("wcnqexmvaovkgoxx")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value The thumbprint of bound certificate.
     */
    @JvmName("oxdxvegjgrcyojrd")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): GatewayCustomDomainPropertiesArgs = GatewayCustomDomainPropertiesArgs(
        thumbprint = thumbprint,
    )
}
