@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetApiPortalCustomDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiPortalName The name of API portal.
 * @property domainName The name of the API portal custom domain.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetApiPortalCustomDomainPlainArgs(
    public val apiPortalName: String,
    public val domainName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetApiPortalCustomDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetApiPortalCustomDomainPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetApiPortalCustomDomainPlainArgs.builder()
            .apiPortalName(apiPortalName.let({ args0 -> args0 }))
            .domainName(domainName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiPortalCustomDomainPlainArgs].
 */
@PulumiTagMarker
public class GetApiPortalCustomDomainPlainArgsBuilder internal constructor() {
    private var apiPortalName: String? = null

    private var domainName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of API portal.
     */
    @JvmName("jkqceybrvnkvmptk")
    public suspend fun apiPortalName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiPortalName = mapped
    }

    /**
     * @param value The name of the API portal custom domain.
     */
    @JvmName("lpyjwuwbkfhxqaih")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("bhlxjknccffoejfj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("lweggiudwcqepibg")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetApiPortalCustomDomainPlainArgs = GetApiPortalCustomDomainPlainArgs(
        apiPortalName = apiPortalName ?: throw PulumiNullFieldException("apiPortalName"),
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
