@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetAppPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appName The name of the App resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property syncStatus Indicates whether sync status
 */
public data class GetAppPlainArgs(
    public val appName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val syncStatus: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetAppPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetAppPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetAppPlainArgs.builder()
            .appName(appName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .syncStatus(syncStatus?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppPlainArgs].
 */
@PulumiTagMarker
public class GetAppPlainArgsBuilder internal constructor() {
    private var appName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var syncStatus: String? = null

    /**
     * @param value The name of the App resource.
     */
    @JvmName("hmbjsiatgvsmxrlm")
    public suspend fun appName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ssihdcpdreiqghjq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("sbinswfitjfdokkt")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Indicates whether sync status
     */
    @JvmName("odriwlwiaruwsntj")
    public suspend fun syncStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.syncStatus = mapped
    }

    internal fun build(): GetAppPlainArgs = GetAppPlainArgs(
        appName = appName ?: throw PulumiNullFieldException("appName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        syncStatus = syncStatus,
    )
}
