@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetBindingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appName The name of the App resource.
 * @property bindingName The name of the Binding resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetBindingPlainArgs(
    public val appName: String,
    public val bindingName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetBindingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetBindingPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetBindingPlainArgs.builder()
            .appName(appName.let({ args0 -> args0 }))
            .bindingName(bindingName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBindingPlainArgs].
 */
@PulumiTagMarker
public class GetBindingPlainArgsBuilder internal constructor() {
    private var appName: String? = null

    private var bindingName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the App resource.
     */
    @JvmName("rxphhffyvlbcctsm")
    public suspend fun appName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appName = mapped
    }

    /**
     * @param value The name of the Binding resource.
     */
    @JvmName("curdqhghyvfcehbn")
    public suspend fun bindingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bindingName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("mobghxuovrohxfey")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("seqkyndoscdrsrti")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetBindingPlainArgs = GetBindingPlainArgs(
        appName = appName ?: throw PulumiNullFieldException("appName"),
        bindingName = bindingName ?: throw PulumiNullFieldException("bindingName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
