@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetBuildpackBindingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property buildServiceName The name of the build service resource.
 * @property builderName The name of the builder resource.
 * @property buildpackBindingName The name of the Buildpack Binding Name
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetBuildpackBindingPlainArgs(
    public val buildServiceName: String,
    public val builderName: String,
    public val buildpackBindingName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetBuildpackBindingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetBuildpackBindingPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetBuildpackBindingPlainArgs.builder()
            .buildServiceName(buildServiceName.let({ args0 -> args0 }))
            .builderName(builderName.let({ args0 -> args0 }))
            .buildpackBindingName(buildpackBindingName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBuildpackBindingPlainArgs].
 */
@PulumiTagMarker
public class GetBuildpackBindingPlainArgsBuilder internal constructor() {
    private var buildServiceName: String? = null

    private var builderName: String? = null

    private var buildpackBindingName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("olwurmptfibrftwi")
    public suspend fun buildServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.buildServiceName = mapped
    }

    /**
     * @param value The name of the builder resource.
     */
    @JvmName("knddsllnllnsexhk")
    public suspend fun builderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.builderName = mapped
    }

    /**
     * @param value The name of the Buildpack Binding Name
     */
    @JvmName("pktmxoyjiwshtusi")
    public suspend fun buildpackBindingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.buildpackBindingName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dncsanwpuasdnesd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("dijuvhqimerwbnic")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetBuildpackBindingPlainArgs = GetBuildpackBindingPlainArgs(
        buildServiceName = buildServiceName ?: throw PulumiNullFieldException("buildServiceName"),
        builderName = builderName ?: throw PulumiNullFieldException("builderName"),
        buildpackBindingName = buildpackBindingName ?: throw
            PulumiNullFieldException("buildpackBindingName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
