@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetCustomizedAcceleratorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationAcceleratorName The name of the application accelerator.
 * @property customizedAcceleratorName The name of the customized accelerator.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetCustomizedAcceleratorPlainArgs(
    public val applicationAcceleratorName: String,
    public val customizedAcceleratorName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetCustomizedAcceleratorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetCustomizedAcceleratorPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetCustomizedAcceleratorPlainArgs.builder()
            .applicationAcceleratorName(applicationAcceleratorName.let({ args0 -> args0 }))
            .customizedAcceleratorName(customizedAcceleratorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomizedAcceleratorPlainArgs].
 */
@PulumiTagMarker
public class GetCustomizedAcceleratorPlainArgsBuilder internal constructor() {
    private var applicationAcceleratorName: String? = null

    private var customizedAcceleratorName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the application accelerator.
     */
    @JvmName("exyjpqcdlmswoljj")
    public suspend fun applicationAcceleratorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationAcceleratorName = mapped
    }

    /**
     * @param value The name of the customized accelerator.
     */
    @JvmName("hbnbnymnavnaukgk")
    public suspend fun customizedAcceleratorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customizedAcceleratorName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qckjcvewcpsopkjb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("lqjksxgidqulpyes")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetCustomizedAcceleratorPlainArgs = GetCustomizedAcceleratorPlainArgs(
        applicationAcceleratorName = applicationAcceleratorName ?: throw
            PulumiNullFieldException("applicationAcceleratorName"),
        customizedAcceleratorName = customizedAcceleratorName ?: throw
            PulumiNullFieldException("customizedAcceleratorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
