@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GitPatternRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Git repository property payload for config server
 * @property hostKey Public sshKey of git repository.
 * @property hostKeyAlgorithm SshKey algorithm of git repository.
 * @property label Label of the repository
 * @property name Name of the repository
 * @property password Password of git repository basic auth.
 * @property pattern Collection of pattern of the repository
 * @property privateKey Private sshKey algorithm of git repository.
 * @property searchPaths Searching path of the repository
 * @property strictHostKeyChecking Strict host key checking or not.
 * @property uri URI of the repository
 * @property username Username of git repository basic auth.
 */
public data class GitPatternRepositoryArgs(
    public val hostKey: Output<String>? = null,
    public val hostKeyAlgorithm: Output<String>? = null,
    public val label: Output<String>? = null,
    public val name: Output<String>,
    public val password: Output<String>? = null,
    public val pattern: Output<List<String>>? = null,
    public val privateKey: Output<String>? = null,
    public val searchPaths: Output<List<String>>? = null,
    public val strictHostKeyChecking: Output<Boolean>? = null,
    public val uri: Output<String>,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GitPatternRepositoryArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GitPatternRepositoryArgs =
        com.pulumi.azurenative.appplatform.inputs.GitPatternRepositoryArgs.builder()
            .hostKey(hostKey?.applyValue({ args0 -> args0 }))
            .hostKeyAlgorithm(hostKeyAlgorithm?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .pattern(pattern?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .searchPaths(searchPaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .strictHostKeyChecking(strictHostKeyChecking?.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitPatternRepositoryArgs].
 */
@PulumiTagMarker
public class GitPatternRepositoryArgsBuilder internal constructor() {
    private var hostKey: Output<String>? = null

    private var hostKeyAlgorithm: Output<String>? = null

    private var label: Output<String>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var pattern: Output<List<String>>? = null

    private var privateKey: Output<String>? = null

    private var searchPaths: Output<List<String>>? = null

    private var strictHostKeyChecking: Output<Boolean>? = null

    private var uri: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Public sshKey of git repository.
     */
    @JvmName("gxejormfcbdlunuy")
    public suspend fun hostKey(`value`: Output<String>) {
        this.hostKey = value
    }

    /**
     * @param value SshKey algorithm of git repository.
     */
    @JvmName("ucrygmslvwfxjccq")
    public suspend fun hostKeyAlgorithm(`value`: Output<String>) {
        this.hostKeyAlgorithm = value
    }

    /**
     * @param value Label of the repository
     */
    @JvmName("nijbfhoaajlvqhpw")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Name of the repository
     */
    @JvmName("ustujragleanbkrx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Password of git repository basic auth.
     */
    @JvmName("lnewxriuykyorlsh")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Collection of pattern of the repository
     */
    @JvmName("evpiwyjnrkplvamh")
    public suspend fun pattern(`value`: Output<List<String>>) {
        this.pattern = value
    }

    @JvmName("euaoulbbvljntyba")
    public suspend fun pattern(vararg values: Output<String>) {
        this.pattern = Output.all(values.asList())
    }

    /**
     * @param values Collection of pattern of the repository
     */
    @JvmName("lbqlukixsxnthiic")
    public suspend fun pattern(values: List<Output<String>>) {
        this.pattern = Output.all(values)
    }

    /**
     * @param value Private sshKey algorithm of git repository.
     */
    @JvmName("jlloplhhokotnmdb")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value Searching path of the repository
     */
    @JvmName("lrarllhyppekldux")
    public suspend fun searchPaths(`value`: Output<List<String>>) {
        this.searchPaths = value
    }

    @JvmName("yyknwxyalobenpam")
    public suspend fun searchPaths(vararg values: Output<String>) {
        this.searchPaths = Output.all(values.asList())
    }

    /**
     * @param values Searching path of the repository
     */
    @JvmName("ampbaymwoyobqjrn")
    public suspend fun searchPaths(values: List<Output<String>>) {
        this.searchPaths = Output.all(values)
    }

    /**
     * @param value Strict host key checking or not.
     */
    @JvmName("frvslnxcvicrxokx")
    public suspend fun strictHostKeyChecking(`value`: Output<Boolean>) {
        this.strictHostKeyChecking = value
    }

    /**
     * @param value URI of the repository
     */
    @JvmName("hnmjobmbodvxikex")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Username of git repository basic auth.
     */
    @JvmName("xnodvxyhqbclnfab")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Public sshKey of git repository.
     */
    @JvmName("iophhsdeoxeljund")
    public suspend fun hostKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKey = mapped
    }

    /**
     * @param value SshKey algorithm of git repository.
     */
    @JvmName("lxjbfngjubdabouw")
    public suspend fun hostKeyAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKeyAlgorithm = mapped
    }

    /**
     * @param value Label of the repository
     */
    @JvmName("etrkhathiseefvye")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Name of the repository
     */
    @JvmName("sldrcdjbotatmrmr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Password of git repository basic auth.
     */
    @JvmName("olpghllfelraufec")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Collection of pattern of the repository
     */
    @JvmName("rponvatrwdhshbba")
    public suspend fun pattern(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    /**
     * @param values Collection of pattern of the repository
     */
    @JvmName("ltrimooypwlybvnq")
    public suspend fun pattern(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    /**
     * @param value Private sshKey algorithm of git repository.
     */
    @JvmName("akkewsmpssgpgvxi")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value Searching path of the repository
     */
    @JvmName("iyuknvxtswevdlvb")
    public suspend fun searchPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchPaths = mapped
    }

    /**
     * @param values Searching path of the repository
     */
    @JvmName("sbuljovlfeflkqju")
    public suspend fun searchPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchPaths = mapped
    }

    /**
     * @param value Strict host key checking or not.
     */
    @JvmName("ykmhpqwsygxorxtb")
    public suspend fun strictHostKeyChecking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strictHostKeyChecking = mapped
    }

    /**
     * @param value URI of the repository
     */
    @JvmName("hcddtqcjdxaneopw")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value Username of git repository basic auth.
     */
    @JvmName("fpgpvgwfdddglahj")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): GitPatternRepositoryArgs = GitPatternRepositoryArgs(
        hostKey = hostKey,
        hostKeyAlgorithm = hostKeyAlgorithm,
        label = label,
        name = name ?: throw PulumiNullFieldException("name"),
        password = password,
        pattern = pattern,
        privateKey = privateKey,
        searchPaths = searchPaths,
        strictHostKeyChecking = strictHostKeyChecking,
        uri = uri ?: throw PulumiNullFieldException("uri"),
        username = username,
    )
}
