@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ImageRegistryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Credential of the image registry
 * @property password The password of the image registry credential
 * @property username The username of the image registry credential
 */
public data class ImageRegistryCredentialArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ImageRegistryCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ImageRegistryCredentialArgs =
        com.pulumi.azurenative.appplatform.inputs.ImageRegistryCredentialArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRegistryCredentialArgs].
 */
@PulumiTagMarker
public class ImageRegistryCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password of the image registry credential
     */
    @JvmName("htnwhasrcydxmtyw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The username of the image registry credential
     */
    @JvmName("ayyargdbydwmwcta")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password of the image registry credential
     */
    @JvmName("ryifsqynjmmauxyx")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The username of the image registry credential
     */
    @JvmName("itnpwkueybyvcbsj")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ImageRegistryCredentialArgs = ImageRegistryCredentialArgs(
        password = password,
        username = username,
    )
}
