@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ScaleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure Spring Apps scaling configurations.
 * @property maxReplicas Optional. Maximum number of container replicas. Defaults to 10 if not set.
 * @property minReplicas Optional. Minimum number of container replicas.
 * @property rules Scaling rules.
 */
public data class ScaleArgs(
    public val maxReplicas: Output<Int>? = null,
    public val minReplicas: Output<Int>? = null,
    public val rules: Output<List<ScaleRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ScaleArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ScaleArgs =
        com.pulumi.azurenative.appplatform.inputs.ScaleArgs.builder()
            .maxReplicas(maxReplicas?.applyValue({ args0 -> args0 }))
            .minReplicas(minReplicas?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScaleArgs].
 */
@PulumiTagMarker
public class ScaleArgsBuilder internal constructor() {
    private var maxReplicas: Output<Int>? = null

    private var minReplicas: Output<Int>? = null

    private var rules: Output<List<ScaleRuleArgs>>? = null

    /**
     * @param value Optional. Maximum number of container replicas. Defaults to 10 if not set.
     */
    @JvmName("mkjdflxvmlcyngig")
    public suspend fun maxReplicas(`value`: Output<Int>) {
        this.maxReplicas = value
    }

    /**
     * @param value Optional. Minimum number of container replicas.
     */
    @JvmName("gsioadjtionwaldd")
    public suspend fun minReplicas(`value`: Output<Int>) {
        this.minReplicas = value
    }

    /**
     * @param value Scaling rules.
     */
    @JvmName("wiquajqjfcakvqto")
    public suspend fun rules(`value`: Output<List<ScaleRuleArgs>>) {
        this.rules = value
    }

    @JvmName("bnktvmdflgkhkakq")
    public suspend fun rules(vararg values: Output<ScaleRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Scaling rules.
     */
    @JvmName("fracqcbrymfttowl")
    public suspend fun rules(values: List<Output<ScaleRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Optional. Maximum number of container replicas. Defaults to 10 if not set.
     */
    @JvmName("lvngnduydugubbii")
    public suspend fun maxReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxReplicas = mapped
    }

    /**
     * @param value Optional. Minimum number of container replicas.
     */
    @JvmName("lisyxspprnvpeeia")
    public suspend fun minReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReplicas = mapped
    }

    /**
     * @param value Scaling rules.
     */
    @JvmName("reepejmioydtefrc")
    public suspend fun rules(`value`: List<ScaleRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Scaling rules.
     */
    @JvmName("kbpionbowvaqfywq")
    public suspend fun rules(argument: List<suspend ScaleRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ScaleRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Scaling rules.
     */
    @JvmName("rafjofbhwjbgwtte")
    public suspend fun rules(vararg argument: suspend ScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ScaleRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Scaling rules.
     */
    @JvmName("flkcntduofvpanip")
    public suspend fun rules(argument: suspend ScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScaleRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Scaling rules.
     */
    @JvmName("nbqmblhfpoufgteh")
    public suspend fun rules(vararg values: ScaleRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): ScaleArgs = ScaleArgs(
        maxReplicas = maxReplicas,
        minReplicas = minReplicas,
        rules = rules,
    )
}
