@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ScaleRuleAuthArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auth Secrets for Azure Spring Apps App Instance Scale Rule
 * @property secretRef Name of the Azure Spring Apps App Instance secret from which to pull the auth params.
 * @property triggerParameter Trigger Parameter that uses the secret
 */
public data class ScaleRuleAuthArgs(
    public val secretRef: Output<String>? = null,
    public val triggerParameter: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ScaleRuleAuthArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ScaleRuleAuthArgs =
        com.pulumi.azurenative.appplatform.inputs.ScaleRuleAuthArgs.builder()
            .secretRef(secretRef?.applyValue({ args0 -> args0 }))
            .triggerParameter(triggerParameter?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScaleRuleAuthArgs].
 */
@PulumiTagMarker
public class ScaleRuleAuthArgsBuilder internal constructor() {
    private var secretRef: Output<String>? = null

    private var triggerParameter: Output<String>? = null

    /**
     * @param value Name of the Azure Spring Apps App Instance secret from which to pull the auth params.
     */
    @JvmName("pmbqnaleohpmrcdo")
    public suspend fun secretRef(`value`: Output<String>) {
        this.secretRef = value
    }

    /**
     * @param value Trigger Parameter that uses the secret
     */
    @JvmName("abuxlwyrwshddnhr")
    public suspend fun triggerParameter(`value`: Output<String>) {
        this.triggerParameter = value
    }

    /**
     * @param value Name of the Azure Spring Apps App Instance secret from which to pull the auth params.
     */
    @JvmName("rfocymwmpegljvcq")
    public suspend fun secretRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretRef = mapped
    }

    /**
     * @param value Trigger Parameter that uses the secret
     */
    @JvmName("ouxgqeipkumuqvsu")
    public suspend fun triggerParameter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerParameter = mapped
    }

    internal fun build(): ScaleRuleAuthArgs = ScaleRuleAuthArgs(
        secretRef = secretRef,
        triggerParameter = triggerParameter,
    )
}
