@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.StackPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * KPack ClusterStack properties payload
 * @property id Id of the ClusterStack.
 * @property version Version of the ClusterStack
 */
public data class StackPropertiesArgs(
    public val id: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.StackPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.StackPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.StackPropertiesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackPropertiesArgs].
 */
@PulumiTagMarker
public class StackPropertiesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Id of the ClusterStack.
     */
    @JvmName("luthjfiapvfefyfv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Version of the ClusterStack
     */
    @JvmName("abitsvurqsycvbae")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Id of the ClusterStack.
     */
    @JvmName("tqpttdmqojtwgrth")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Version of the ClusterStack
     */
    @JvmName("lxhjdrbfluvjtijj")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): StackPropertiesArgs = StackPropertiesArgs(
        id = id,
        version = version,
    )
}
